package org.mule.datasense.impl.phases.typing.resolver.munit;

import static org.mule.datasense.impl.phases.builder.MuleAstParser.MULE_MUNIT;
import static org.mule.datasense.impl.phases.builder.MuleAstParser.MULE_MUNIT_PREFIX;
import static org.mule.runtime.api.meta.model.parameter.ParameterGroupModel.DEFAULT_GROUP_NAME;

import org.mule.datasense.impl.model.event.ExprBuilder;
import org.mule.datasense.impl.model.event.LiteralValueExprBuilder;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.event.SimpleExprBuilder;
import org.mule.datasense.impl.model.event.ValueExprBuilder;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.ast.api.ComponentAst;

import java.util.List;

public class MUnitSetEventParser {

  private static final ComponentIdentifier VARIABLE =
      ComponentIdentifierUtils.createFromNamespaceAndName(MULE_MUNIT_PREFIX, MULE_MUNIT, "variable");
  private static final String ATTR_VARIABLE_NAME = "key";
  private static final String ATTR_VALUE = "value";
  private static final String ATTR_MEDIA_TYPE = "mediaType";

  private ExprBuilder buildExprBuilder(Either<String, String> attributeValue, String mediaType) {
    final ExprBuilder exprBuilder = attributeValue
        .mapLeft(SimpleExprBuilder::new)
        .mapRight(LiteralValueExprBuilder::new)
        .<ExprBuilder>getValue()
        .orElseGet(() -> new LiteralValueExprBuilder(null));
    exprBuilder.mimeType(mediaType);
    return exprBuilder;
  }

  private void parseVariables(List<ComponentAst> componentModels, MuleEventExprBuilder muleEventExprBuilder) {
    componentModels.forEach(variableComponentModel -> {
      String name = (String) variableComponentModel.getParameter("Variable", ATTR_VARIABLE_NAME).getValue().getRight();

      final ExprBuilder exprBuilder =
          buildExprBuilder(variableComponentModel.getParameter("Variable", ATTR_VALUE).getValue(),
                           (String) variableComponentModel.getParameter("Variable", ATTR_MEDIA_TYPE).getValue()
                               .getRight());
      muleEventExprBuilder.variable(name, v -> {
        v.value(new ValueExprBuilder(exprBuilder));
      });
    });
  }

  public void parse(ComponentAst setEventComponentModel, MuleEventExprBuilder muleEventExprBuilder) {
    setEventComponentModel.getParameter(DEFAULT_GROUP_NAME, "payload").getValue()
        .applyRight(payloadModel -> muleEventExprBuilder.message(m -> m.value(m1 -> m1
            .payload(buildExprBuilder(((ComponentAst) payloadModel).getParameter("Payload", ATTR_VALUE).getValue(),
                                      (String) ((ComponentAst) payloadModel).getParameter("Payload", ATTR_MEDIA_TYPE)
                                          .getValue()
                                          .getRight())))));

    setEventComponentModel.getParameter(DEFAULT_GROUP_NAME, "attributes").getValue()
        .applyRight(attributesModel -> muleEventExprBuilder.message(m -> m.value(m1 -> m1
            .attributes(buildExprBuilder(((ComponentAst) attributesModel).getParameter("EventAttributes", ATTR_VALUE).getValue(),
                                         (String) ((ComponentAst) attributesModel)
                                             .getParameter("EventAttributes", ATTR_MEDIA_TYPE).getValue()
                                             .getRight())))));

    setEventComponentModel.getParameter(DEFAULT_GROUP_NAME, "variables").getValue()
        .applyRight(variablesModel -> parseVariables((List<ComponentAst>) variablesModel, muleEventExprBuilder));
  }
}
