package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.util.MessageCallbackFactory;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

import com.google.common.base.Preconditions;

public class ResolveTypeContext {

  private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
  private MessageCallbackFactory messageCallbackFactory;
  private TypeBindings typeBindings;

  public ResolveTypeContext(ExpressionLanguageMetadataService expressionLanguageMetadataService,
                            MessageCallbackFactory messageCallbackFactory, TypeBindings typeBindings) {
    this.typeBindings = typeBindings;
    Preconditions.checkNotNull(expressionLanguageMetadataService);
    Preconditions.checkNotNull(messageCallbackFactory);
    this.expressionLanguageMetadataService = expressionLanguageMetadataService;
    this.messageCallbackFactory = messageCallbackFactory;
  }

  public ExpressionLanguageMetadataService getExpressionLanguageMetadataService() {
    return expressionLanguageMetadataService;
  }

  public MessageCallbackFactory getMessageCallbackFactory() {
    return messageCallbackFactory;
  }

  public TypeBindings getTypeBindings() {
    return typeBindings;
  }
}
