package org.mule.datasense.impl.model.types;

import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.LocalDateTimeType;
import org.mule.metadata.api.model.LocalTimeType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NothingType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.PeriodType;
import org.mule.metadata.api.model.RegexType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.model.TimeZoneType;
import org.mule.metadata.api.model.TypeParameterType;
import org.mule.metadata.api.model.UnionType;

import javax.xml.namespace.QName;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TypeEquivalence {

  private static class TypeParametersContext {

    Map<String, MetadataType> context;

    public TypeParametersContext() {
      context = new HashMap<>();
    }

    public Optional<MetadataType> get(String name) {
      return Optional.ofNullable(context.get(name));
    }
  }

  public static boolean canBeAssignedTo(MetadataType assignmentType, MetadataType expectedType,
                                        Optional<TypeParametersContext> ctx) {
    boolean result;
    if (assignmentType instanceof UnionType) {
      UnionType assignmentUnionType = (UnionType) assignmentType;
      List<MetadataType> of = assignmentUnionType.getTypes();
      result = !of.stream().anyMatch(t -> !canBeAssignedTo(t, expectedType, Optional.empty()));
    } else if (assignmentType instanceof NothingType) {
      result = true;
    } else {
      if (expectedType instanceof ObjectType) {
        ObjectType expectedObjectType = (ObjectType) expectedType;
        Collection<ObjectFieldType> expectedProperties = expectedObjectType.getFields();
        if (assignmentType instanceof ObjectType) {
          ObjectType assignmentObjectType = (ObjectType) assignmentType;
          Collection<ObjectFieldType> assignedProperties = assignmentObjectType.getFields();
          result =
              !expectedProperties.stream().anyMatch(expectedProperty -> !(!expectedProperty.isRequired() || assignedProperties
                  .stream().anyMatch(assignedProperty -> canBeAssignedTo(assignedProperty, expectedProperty, ctx))));
        } else {
          result = false;
        }
      } else if (expectedType instanceof ObjectFieldType) {
        ObjectFieldType expectedObjectFieldType = (ObjectFieldType) expectedType;
        ObjectKeyType expectedKey = expectedObjectFieldType.getKey();
        MetadataType expectedValue = expectedObjectFieldType.getValue();
        boolean optional = !expectedObjectFieldType.isRequired();
        if (assignmentType instanceof ObjectFieldType) {
          ObjectFieldType assignmentObjectFieldType = (ObjectFieldType) assignmentType;
          result = canBeAssignedTo(assignmentObjectFieldType.getKey(), expectedKey, ctx) &&
              canBeAssignedTo(assignmentObjectFieldType.getValue(), expectedValue, ctx);
        } else {
          result = false;
        }
      } else if (expectedType instanceof ObjectKeyType) {
        ObjectKeyType expectedObjectKeyType = (ObjectKeyType) expectedType;
        QName expectedName = expectedObjectKeyType.getName();
        Collection<AttributeFieldType> expectedAttributes = expectedObjectKeyType.getAttributes();
        if (assignmentType instanceof ObjectKeyType) {
          ObjectKeyType assignedKey = (ObjectKeyType) assignmentType;
          result = assignedKey.getName().equals(expectedName) &&
              !expectedAttributes.stream().anyMatch(expectedAttr -> !assignedKey.getAttributes().stream()
                  .anyMatch(assignedAttr -> canBeAssignedTo(assignedAttr, expectedAttr, ctx)));
        } else {
          result = false;
        }
      } else if (expectedType instanceof ArrayType) {
        ArrayType expectedArrayType = (ArrayType) expectedType;
        MetadataType expectedItemType = expectedArrayType.getType();
        if (assignmentType instanceof ArrayType) {
          ArrayType assignmentArrayType = (ArrayType) assignmentType;
          MetadataType assignmentItemType = assignmentArrayType.getType();
          result = canBeAssignedTo(assignmentItemType, expectedItemType, ctx);
        } else {
          result = false;
        }
      } else if (expectedType instanceof UnionType) {
        List<MetadataType> expectedTypes = ((UnionType) expectedType).getTypes();
        if (assignmentType instanceof UnionType) {
          List<MetadataType> assignedTypes = ((UnionType) assignmentType).getTypes();
          result = !assignedTypes.stream().anyMatch(actualType -> !expectedTypes.stream()
              .anyMatch(innerExpectedType -> canBeAssignedTo(actualType, innerExpectedType, ctx)));
        } else {
          result = expectedTypes.stream().anyMatch(wtype -> canBeAssignedTo(assignmentType, wtype, ctx));
        }
      } else if (expectedType instanceof TypeParameterType) {
        TypeParameterType expectedTypeParameterType = (TypeParameterType) expectedType;
        String name = expectedTypeParameterType.getName();
        // baseType
        /*
                ctx.map(
                    typeParametersContext ->
                        typeParametersContext.get(name).ifPresent(metadataType -> isAssignable(metadataType, assignmentType, ctx))).orElse(true);
        */
        result = false;
      } else if (expectedType instanceof FunctionType) {
        // TODO: 11/16/16
        result = false;
      } else if (expectedType instanceof AnyType) {
        result = true;
      } else if (expectedType instanceof StringType) {
        result = assignmentType instanceof StringType;
      } else if (expectedType instanceof BooleanType) {
        result = assignmentType instanceof BooleanType;
      } else if (expectedType instanceof NumberType) {
        result = assignmentType instanceof NumberType;
      } else if (expectedType instanceof DateTimeType) {
        result = assignmentType instanceof DateTimeType;
      } else if (expectedType instanceof LocalDateTimeType) {
        result = assignmentType instanceof LocalDateTimeType;
      } else if (expectedType instanceof LocalTimeType) {
        result = assignmentType instanceof LocalTimeType;
      } else if (expectedType instanceof TimeType) {
        result = assignmentType instanceof TimeType;
      } else if (expectedType instanceof TimeZoneType) {
        result = assignmentType instanceof TimeZoneType;
      } else if (expectedType instanceof PeriodType) {
        result = assignmentType instanceof PeriodType;
      } else if (expectedType instanceof BinaryType) {
        result = assignmentType instanceof BinaryType;
      } else if (expectedType instanceof RegexType) {
        result = assignmentType instanceof RegexType;
      } else if (expectedType instanceof NullType) {
        result = assignmentType instanceof NullType;
      } else {
        //        throw new IllegalArgumentException(String.format("Unsupported assignable check %s, %s", assignmentType, expectedType));
        result = false; // TODO: 12/14/16 until better handling for dictionary type
      }
    }
    return result;

  }

}
