package org.mule.datasense.impl.util;

import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

import com.google.common.base.Preconditions;

public class AstMessageCallbackFactory implements MessageCallbackFactory {

  private final AstNotification astNotification;
  private final AstNodeLocation astNodeLocation;

  public AstMessageCallbackFactory(AstNotification astNotification, AstNodeLocation astNodeLocation) {
    Preconditions.checkNotNull(astNotification);
    Preconditions.checkNotNull(astNodeLocation);

    this.astNotification = astNotification;
    this.astNodeLocation = astNodeLocation;
  }

  public ExpressionLanguageMetadataService.MessageCallback createMessageCallback(String expression) {
    return new ExpressionLanguageMetadataService.MessageCallback() {

      @Override
      public void warning(String message, ExpressionLanguageMetadataService.MessageLocation messageLocation) {
        astNotification.reportWarning(astNodeLocation, NotificationMessages.MSG_SCRIPTING_LANGUAGE_WARNING(expression, message));
      }

      @Override
      public void error(String message, ExpressionLanguageMetadataService.MessageLocation messageLocation) {
        astNotification.reportError(astNodeLocation, NotificationMessages.MSG_SCRIPTING_LANGUAGE_ERROR(expression, message));
      }
    };
  }
}
