/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.datasense.impl.tooling;

import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.ExpectedEventAnnotation;
import org.mule.datasense.impl.model.annotations.ExpectedInputAnnotation;
import org.mule.datasense.impl.model.annotations.IncomingEventAnnotation;
import org.mule.datasense.impl.model.annotations.ResultEventAnnotation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.runtime.api.component.location.Location;

import java.util.Optional;

/**
 *
 */
public class TypeContextQuery implements TypedApplicationQuery<TypeContextQueryResult> {

  private final Location location;

  public TypeContextQuery(
                          Location location) {

    this.location = location;
  }

  // incoming upstream / expected downstream mule event types

  /**
   * @param muleApplicationNode
   * @param dataSenseProviderResolver
   * @param astNotification
   * @return
   */
  @Override
  public Optional<TypeContextQueryResult> perform(MuleApplicationNode muleApplicationNode,
                                                  DataSenseProviderResolver dataSenseProviderResolver,
                                                  AstNotification astNotification) {
    return muleApplicationNode
        .findMessageProcessorNode(location)
        .map(messageProcessorNode -> new TypeContextQueryResult(
                                                                messageProcessorNode
                                                                    .getAnnotation(IncomingEventAnnotation.class).map(
                                                                                                                      incomingEventAnnotation -> TypeUtils
                                                                                                                          .asMuleEventMetadataType(incomingEventAnnotation
                                                                                                                              .getEventType())
                                                                                                                          .build())
                                                                    .orElse(null),
                                                                messageProcessorNode
                                                                    .getAnnotation(ExpectedEventAnnotation.class).map(
                                                                                                                      expectedEventAnnotation -> TypeUtils
                                                                                                                          .asMuleEventMetadataType(expectedEventAnnotation
                                                                                                                              .getEventType())
                                                                                                                          .build())
                                                                    .orElse(null),
                                                                messageProcessorNode
                                                                    .getAnnotation(ResultEventAnnotation.class).map(
                                                                                                                    resultEventAnnotation -> TypeUtils
                                                                                                                        .asMuleEventMetadataType(resultEventAnnotation
                                                                                                                            .getResultEventType())
                                                                                                                        .build())
                                                                    .orElse(null),
                                                                messageProcessorNode
                                                                    .getAnnotation(ExpectedInputAnnotation.class).map(
                                                                                                                      eventAnnotation -> TypeUtils
                                                                                                                          .asMuleEventMetadataType(eventAnnotation
                                                                                                                              .getEventType())
                                                                                                                          .build())
                                                                    .orElse(null)));
  }
}
