package org.mule.datasense.impl.model.ast;

import org.mule.runtime.api.component.ComponentIdentifier;

import java.util.Optional;
import java.util.Set;

public interface AstNode {

  ComponentIdentifier getIdentifier();

  String getName();

  AstNodeLocation getAstNodeLocation();

  <T> Object accept(AstNodeVisitor<T> astNodeVisitor, T context);

  Set<AstNodeAnnotation> getAnnotations();

  <T extends AstNodeAnnotation> Optional<T> getAnnotation(Class<T> annotation);

  <T extends AstNodeAnnotation> boolean isAnnotatedWith(Class<T> annotationClass);

}
