/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util.bindings;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.text.StrBuilder;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.metadata.message.api.el.ModuleDefinition;
import org.mule.metadata.message.api.el.ModuleIdentifier;
import org.mule.metadata.message.api.el.TypeBindings;

public class TypeBindingUtils {
    public static String toString(TypeBindings typeBindings) {
        if (typeBindings == null) {
            return "";
        }
        StrBuilder strBuilder = new StrBuilder();
        typeBindings.identifiers().forEach(identifier -> strBuilder.append(String.format("%s: %s\n", identifier, TypesHelper.toString((MetadataType)typeBindings.lookup(identifier).orElseThrow(IllegalArgumentException::new)))));
        typeBindings.modules().forEach(moduleDefinition -> {
            strBuilder.append(String.format("%s\n", moduleDefinition.getName()));
            moduleDefinition.identifiers().forEach(identifier -> strBuilder.append(String.format("\t%s: %s\n", identifier, TypesHelper.toString((MetadataType)moduleDefinition.lookup(identifier).orElseThrow(IllegalArgumentException::new)))));
        });
        return strBuilder.toString();
    }

    public static Map<String, MetadataType> toMap(TypeBindings typeBindings) {
        if (typeBindings == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, MetadataType> result = new LinkedHashMap<String, MetadataType>();
        typeBindings.identifiers().forEach(identifier -> typeBindings.lookup(identifier).ifPresent(metadataType -> result.put((String)identifier, (MetadataType)metadataType)));
        typeBindings.modules().forEach(moduleDefinition -> {
            ModuleIdentifier moduleIdentifier = moduleDefinition.getName();
            moduleDefinition.identifiers().forEach(identifier -> moduleDefinition.lookup(identifier).ifPresent(metadataType -> result.put(moduleIdentifier + "::" + identifier, (MetadataType)metadataType)));
        });
        return result;
    }

    public static TypeBindings fromMap(Map<String, MetadataType> typeBindingsMap) {
        if (typeBindingsMap == null) {
            return TypeBindings.builder().build();
        }
        LinkedHashMap<String, MetadataType> bindings = new LinkedHashMap<String, MetadataType>();
        LinkedHashMap<String, Map> modules = new LinkedHashMap<String, Map>();
        typeBindingsMap.forEach((qualifiedIdentifier, metadataType) -> {
            String[] split = qualifiedIdentifier.split("::");
            if (split.length == 2) {
                String module = split[0];
                String identifier = split[1];
                LinkedHashMap<String, MetadataType> moduleBindings = (LinkedHashMap<String, MetadataType>)modules.get(module);
                if (moduleBindings == null) {
                    moduleBindings = new LinkedHashMap<String, MetadataType>();
                    modules.put(module, moduleBindings);
                }
                moduleBindings.put(identifier, (MetadataType)metadataType);
            } else if (split.length == 1) {
                String identifier = split[0];
                bindings.put(identifier, (MetadataType)metadataType);
            } else {
                throw new IllegalArgumentException(String.format("Illegal type binding identifier %s", qualifiedIdentifier));
            }
        });
        TypeBindings.Builder builder = TypeBindings.builder();
        bindings.forEach((arg_0, arg_1) -> ((TypeBindings.Builder)builder).addBinding(arg_0, arg_1));
        modules.forEach((module, moduleBindings) -> {
            ModuleDefinition.Builder moduleBuilder = builder.module(module);
            moduleBindings.forEach((arg_0, arg_1) -> ((ModuleDefinition.Builder)moduleBuilder).addElement(arg_0, arg_1));
        });
        return builder.build();
    }

    public static TypeBindings getTypeBindings(MetadataType muleEventMedataType, Map<String, MetadataType> globalBindings, Map<String, MetadataType> functionBindings) {
        return TypeBindingUtils.getTypeBindings(muleEventMedataType, TypeBindingUtils.fromMap(globalBindings), TypeBindingUtils.fromMap(functionBindings));
    }

    public static TypeBindings getTypeBindings(MetadataType muleEventMedataType, TypeBindings globalBindings, TypeBindings functionBindings) {
        TypeBindings.Builder result = TypeBindings.builder();
        if (globalBindings != null) {
            result.addAll(globalBindings);
        }
        if (functionBindings != null) {
            result.addAll(functionBindings);
        }
        return TypeUtils.buildTypeBindings(TypeUtils.asMuleEventMetadataType(muleEventMedataType).orElse(new MuleEventMetadataTypeBuilder().build()), result.build());
    }
}

