/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.builder;

import java.util.Optional;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.impl.phases.builder.ApplicationResolutionScopeStrategy;
import org.mule.datasense.impl.phases.builder.ComponentModelClassifier;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.ComponentResolutionScopeStrategy;
import org.mule.datasense.impl.phases.builder.ConfigResolutionScopeStrategy;
import org.mule.datasense.impl.phases.builder.DataSenseResolutionScopeStrategy;
import org.mule.datasense.impl.phases.builder.MuleAstParseProvider;
import org.mule.datasense.impl.phases.builder.SimpleDependenciesResolutionScopeStrategy;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.datasense.impl.util.TreeLogSupport;
import org.mule.datasenseapi.api.ApplicationResolutionScope;
import org.mule.datasenseapi.api.ComponentResolutionScope;
import org.mule.datasenseapi.api.ConfigResolutionScope;
import org.mule.datasenseapi.api.DataSenseResolutionScope;
import org.mule.runtime.ast.api.ComponentAst;

public class MuleAstParserContext {
    private final TreeLogSupport treeLogSupport;
    private final ComponentModelClassifier componentModelClassifier;
    private final DataSenseResolutionScopeStrategy dataSenseResolutionScopeStrategy;
    private final TypeResolverRegistry typeResolverRegistry;

    public MuleAstParserContext(ApplicationModel applicationModel, DataSenseProvider dataSenseProvider, ComponentModelClassifier componentModelClassifier) {
        this(applicationModel, dataSenseProvider, componentModelClassifier, null, null);
    }

    public MuleAstParserContext(ApplicationModel applicationModel, DataSenseProvider dataSenseProvider, ComponentModelClassifier componentModelClassifier, DataSenseResolutionScope dataSenseResolutionScope, TypeResolverRegistry typeResolverRegistry) {
        this.componentModelClassifier = componentModelClassifier;
        this.dataSenseResolutionScopeStrategy = MuleAstParserContext.createDataSenseResolutionScopeStrategy(applicationModel, dataSenseProvider, dataSenseResolutionScope);
        this.typeResolverRegistry = typeResolverRegistry;
        this.treeLogSupport = new TreeLogSupport();
    }

    public Optional<DataSenseResolutionScopeStrategy> getDataSenseResolutionScopeStrategy() {
        return Optional.ofNullable(this.dataSenseResolutionScopeStrategy);
    }

    TreeLogSupport astlogger() {
        return this.treeLogSupport;
    }

    void enter(ComponentAst componentModel) {
        this.astlogger().enter(componentModel.getIdentifier().toString());
    }

    void exit(ComponentAst componentModel) {
        this.astlogger().exit(componentModel.getIdentifier().toString());
    }

    public Optional<ComponentModelType> getComponentModelType(ComponentAst componentModel) {
        return this.componentModelClassifier.getComponentModelType(componentModel);
    }

    public Optional<MuleAstParseProvider> getParseProvider(ComponentAst componentModel) {
        return this.typeResolverRegistry.get(componentModel.getIdentifier()).flatMap(TypeResolver::getParseProvider);
    }

    private static DataSenseResolutionScopeStrategy createDataSenseResolutionScopeStrategy(ApplicationModel applicationModel, DataSenseProvider dataSenseProvider, DataSenseResolutionScope dataSenseResolutionScope) {
        if (dataSenseResolutionScope == null) {
            return null;
        }
        if (dataSenseResolutionScope instanceof ApplicationResolutionScope) {
            return new ApplicationResolutionScopeStrategy((ApplicationResolutionScope)dataSenseResolutionScope);
        }
        if (dataSenseResolutionScope instanceof ConfigResolutionScope) {
            return new SimpleDependenciesResolutionScopeStrategy(applicationModel, dataSenseProvider, new ConfigResolutionScopeStrategy((ConfigResolutionScope)dataSenseResolutionScope));
        }
        if (dataSenseResolutionScope instanceof ComponentResolutionScope) {
            return new SimpleDependenciesResolutionScopeStrategy(applicationModel, dataSenseProvider, new ComponentResolutionScopeStrategy((ComponentResolutionScope)dataSenseResolutionScope));
        }
        throw new IllegalArgumentException(String.format("Unknown resolution scope class %s.", dataSenseResolutionScope.getClass()));
    }
}

