/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.scoping;

import java.util.Arrays;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.model.annotations.TypeResolverAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitor;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.datasense.impl.util.TreeLogSupport;
import org.mule.runtime.api.component.ComponentIdentifier;

public class ExpectedAstVisitorTest {
    private ExpectedAstVisitor visitor;
    @Mock
    private ExpectedAstVisitorContext mockContext;
    @Mock
    private TreeLogSupport mockLogger;
    @Mock
    private TypeResolverRegistry mockTypeResolverRegistry;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.visitor = new ExpectedAstVisitor();
        Mockito.when((Object)this.mockContext.logger()).thenReturn((Object)this.mockLogger);
        Mockito.when((Object)this.mockContext.getTypeResolverRegistry()).thenReturn((Object)this.mockTypeResolverRegistry);
    }

    @Test
    public void testVisitMessageProcessorNode() {
        MessageProcessorNode mockNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        TypeResolverAnnotation mockAnnotation = (TypeResolverAnnotation)Mockito.mock(TypeResolverAnnotation.class);
        Mockito.when((Object)mockNode.getName()).thenReturn((Object)"TestProcessor");
        Mockito.when((Object)mockNode.getAnnotation(TypeResolverAnnotation.class)).thenReturn(Optional.of(mockAnnotation));
        Mockito.when((Object)mockAnnotation.getTypeResolver()).thenReturn((Object)((ComponentIdentifier)Mockito.mock(ComponentIdentifier.class)));
        EventType expectedEventType = new EventType();
        Object result = this.visitor.visit(mockNode, this.mockContext);
        ((TreeLogSupport)Mockito.verify((Object)this.mockLogger)).enter("TestProcessor");
        ((TreeLogSupport)Mockito.verify((Object)this.mockLogger)).exit("TestProcessor");
        Assert.assertEquals((Object)expectedEventType, (Object)result);
    }

    @Test
    public void testVisitMessageProcessorNodeWithoutTypeResolver() {
        MessageProcessorNode mockNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)mockNode.getName()).thenReturn((Object)"TestProcessor");
        Mockito.when((Object)mockNode.getAnnotation(TypeResolverAnnotation.class)).thenReturn(Optional.empty());
        Object result = this.visitor.visit(mockNode, this.mockContext);
        ((TreeLogSupport)Mockito.verify((Object)this.mockLogger)).enter("TestProcessor");
        ((TreeLogSupport)Mockito.verify((Object)this.mockLogger)).exit("TestProcessor");
        Assert.assertTrue((boolean)(result instanceof EventType));
    }

    @Test
    public void testVisitMuleApplicationNode() {
        MuleApplicationNode mockAppNode = (MuleApplicationNode)Mockito.mock(MuleApplicationNode.class);
        MuleFlowNode mockFlowNode1 = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        MuleFlowNode mockFlowNode2 = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        Mockito.when((Object)mockAppNode.getName()).thenReturn((Object)"TestApp");
        Mockito.when((Object)mockAppNode.getMuleFlowNodes()).thenReturn(Arrays.asList(mockFlowNode1, mockFlowNode2).stream());
        Object result = this.visitor.visit(mockAppNode, this.mockContext);
        ((TreeLogSupport)Mockito.verify((Object)this.mockLogger)).enter("TestApp");
        ((MuleFlowNode)Mockito.verify((Object)mockFlowNode1)).accept((AstNodeVisitor)this.visitor, (Object)this.mockContext);
        ((MuleFlowNode)Mockito.verify((Object)mockFlowNode2)).accept((AstNodeVisitor)this.visitor, (Object)this.mockContext);
        ((TreeLogSupport)Mockito.verify((Object)this.mockLogger)).exit("TestApp");
        Assert.assertNull((Object)result);
    }

    @Test
    public void testVisitMuleFlowNode() {
        MuleFlowNode mockFlowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        MessageProcessorNode mockRootProcessor = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)mockFlowNode.getName()).thenReturn((Object)"TestFlow");
        Mockito.when((Object)mockFlowNode.getRootMessageProcessorNode()).thenReturn(Optional.of(mockRootProcessor));
        Object result = this.visitor.visit(mockFlowNode, this.mockContext);
        ((TreeLogSupport)Mockito.verify((Object)this.mockLogger)).enter("TestFlow");
        ((ExpectedAstVisitorContext)Mockito.verify((Object)this.mockContext)).setExpectedEventType((EventType)Mockito.any(EventType.class));
        ((MessageProcessorNode)Mockito.verify((Object)mockRootProcessor)).accept((AstNodeVisitor)this.visitor, (Object)this.mockContext);
        ((TreeLogSupport)Mockito.verify((Object)this.mockLogger)).exit("TestFlow");
        Assert.assertNull((Object)result);
    }

    @Test
    public void testVisitMuleFlowNodeWithoutRootProcessor() {
        MuleFlowNode mockFlowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        Mockito.when((Object)mockFlowNode.getName()).thenReturn((Object)"TestFlow");
        Mockito.when((Object)mockFlowNode.getRootMessageProcessorNode()).thenReturn(Optional.empty());
        Object result = this.visitor.visit(mockFlowNode, this.mockContext);
        ((TreeLogSupport)Mockito.verify((Object)this.mockLogger)).enter("TestFlow");
        ((ExpectedAstVisitorContext)Mockito.verify((Object)this.mockContext)).setExpectedEventType((EventType)Mockito.any(EventType.class));
        ((TreeLogSupport)Mockito.verify((Object)this.mockLogger)).exit("TestFlow");
        Assert.assertNull((Object)result);
    }
}

