/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util;

import org.junit.Assert;
import org.junit.Test;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.Location;

public class ComponentIdentifierUtilsTest {
    private static final String TEST_NAMESPACE = "test";
    private static final String TEST_NAME = "component";
    private static final String TEST_NAMESPACE_URI = "http://test.mulesoft.com";
    private static final String TEST_FLOW = "testFlow";
    private static final String TEST_PROCESSOR = "0";
    private static final String TEST_CONFIG = "testConfig";

    @Test
    public void testCreateFromNamespaceAndName() {
        ComponentIdentifier identifier = ComponentIdentifierUtils.createFromNamespaceAndName((String)TEST_NAMESPACE, (String)TEST_NAME);
        Assert.assertNotNull((String)"Identifier should not be null", (Object)identifier);
        Assert.assertEquals((String)"Namespace should match", (Object)TEST_NAMESPACE, (Object)identifier.getNamespace());
        Assert.assertEquals((String)"Name should match", (Object)TEST_NAME, (Object)identifier.getName());
    }

    @Test
    public void testCreateFromNamespaceAndNameWithUri() {
        ComponentIdentifier identifier = ComponentIdentifierUtils.createFromNamespaceAndName((String)TEST_NAMESPACE, (String)TEST_NAMESPACE_URI, (String)TEST_NAME);
        Assert.assertNotNull((String)"Identifier should not be null", (Object)identifier);
        Assert.assertEquals((String)"Namespace should match", (Object)TEST_NAMESPACE, (Object)identifier.getNamespace());
        Assert.assertEquals((String)"Name should match", (Object)TEST_NAME, (Object)identifier.getName());
    }

    @Test
    public void testCreateProcessorIdLocation() {
        Location location = ComponentIdentifierUtils.createProcessorIdLocation((String)TEST_FLOW, (String)TEST_PROCESSOR);
        Assert.assertNotNull((String)"Location should not be null", (Object)location);
        Assert.assertEquals((String)"Location should have correct parts", (Object)"testFlow/processors/0", (Object)location.toString());
    }

    @Test
    public void testCreateSourceIdLocation() {
        Location location = ComponentIdentifierUtils.createSourceIdLocation((String)TEST_FLOW);
        Assert.assertNotNull((String)"Location should not be null", (Object)location);
        Assert.assertEquals((String)"Location should have correct parts", (Object)"testFlow/source", (Object)location.toString());
    }

    @Test
    public void testCreateConfigLocation() {
        Location location = ComponentIdentifierUtils.createConfigLocation((String)TEST_CONFIG);
        Assert.assertNotNull((String)"Location should not be null", (Object)location);
        Assert.assertEquals((String)"Location should have correct parts", (Object)TEST_CONFIG, (Object)location.toString());
    }
}

