/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.datasense.impl.model.annotations.TypeResolverAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.annotators.ConstructAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.ast.api.ComponentAst;

public class ConstructAnnotatorTest {
    private ConstructAnnotator constructAnnotator;
    private MessageProcessorNode messageProcessorNode;
    private AnnotatingMuleAstVisitorContext context;
    private ComponentModel componentModel;

    @Before
    public void setUp() {
        this.constructAnnotator = new ConstructAnnotator();
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.context = (AnnotatingMuleAstVisitorContext)Mockito.mock(AnnotatingMuleAstVisitorContext.class);
        this.componentModel = (ComponentModel)Mockito.mock(ComponentModel.class);
    }

    @Test
    public void testAnnotateRootMessageProcessorNode() {
        Mockito.when((Object)this.messageProcessorNode.isRootMessageProcessorNode()).thenReturn((Object)true);
        this.constructAnnotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).getAnnotation(TypeResolverAnnotation.class);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).getComponentModel();
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).annotate((AstNodeAnnotation)((TypeResolverAnnotation)Mockito.any(TypeResolverAnnotation.class)));
    }

    @Test
    public void testAnnotateNodeWithExistingTypeResolverAnnotation() {
        Mockito.when((Object)this.messageProcessorNode.isRootMessageProcessorNode()).thenReturn((Object)false);
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(TypeResolverAnnotation.class)).thenReturn(Optional.of((TypeResolverAnnotation)Mockito.mock(TypeResolverAnnotation.class)));
        this.constructAnnotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).getComponentModel();
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).annotate((AstNodeAnnotation)((TypeResolverAnnotation)Mockito.any(TypeResolverAnnotation.class)));
    }

    @Test
    public void testAnnotateNodeWithoutTypeResolverAnnotation() {
        Mockito.when((Object)this.messageProcessorNode.isRootMessageProcessorNode()).thenReturn((Object)false);
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(TypeResolverAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        Mockito.when((Object)this.messageProcessorNode.getComponentModel().getModel(ComponentModel.class)).thenReturn(Optional.of(this.componentModel));
        this.constructAnnotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((TypeResolverAnnotation)Mockito.any(TypeResolverAnnotation.class)));
    }

    @Test
    public void testAnnotateNodeWithoutComponentModel() {
        Mockito.when((Object)this.messageProcessorNode.isRootMessageProcessorNode()).thenReturn((Object)false);
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(TypeResolverAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        Mockito.when((Object)this.messageProcessorNode.getComponentModel().getModel(ComponentModel.class)).thenReturn(Optional.empty());
        this.constructAnnotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).annotate((AstNodeAnnotation)((TypeResolverAnnotation)Mockito.any(TypeResolverAnnotation.class)));
    }

    @Test
    public void testAnnotateVerifyTypeResolverAnnotationContent() {
        Mockito.when((Object)this.messageProcessorNode.isRootMessageProcessorNode()).thenReturn((Object)false);
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(TypeResolverAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        Mockito.when((Object)this.messageProcessorNode.getComponentModel().getModel(ComponentModel.class)).thenReturn(Optional.of(this.componentModel));
        this.constructAnnotator.annotate(this.messageProcessorNode, this.context);
        Assert.assertNotNull((Object)this.context);
    }
}

