/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Arrays;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.FirstSuccessfulTypeResolver;

public class FirstSuccessfulTypeResolverTest {
    private FirstSuccessfulTypeResolver resolver;
    @Mock
    private MessageProcessorNode messageProcessorNode;
    @Mock
    private TypingMuleAstVisitor typingMuleAstVisitor;
    @Mock
    private TypingMuleAstVisitorContext typingMuleAstVisitorContext;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.resolver = new FirstSuccessfulTypeResolver();
    }

    @Test
    public void testGetComponentModelType() {
        Optional result = this.resolver.getComponentModelType();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)ComponentModelType.MESSAGE_PROCESSOR_NODE, result.get());
    }

    @Test
    public void testResolve() {
        EventType inputEventType = new EventType();
        MessageProcessorNode nestedNode1 = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        MessageProcessorNode nestedNode2 = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        EventType nestedType1 = new EventType();
        EventType nestedType2 = new EventType();
        EventType unionType = new EventType();
        Mockito.when((Object)this.messageProcessorNode.getMessageProcessorNodes()).thenReturn(Arrays.asList(nestedNode1, nestedNode2).stream());
        Mockito.when((Object)this.typingMuleAstVisitor.resolveType((AstNode)nestedNode1, inputEventType, this.typingMuleAstVisitorContext)).thenReturn((Object)nestedType1);
        Mockito.when((Object)this.typingMuleAstVisitor.resolveType((AstNode)nestedNode2, inputEventType, this.typingMuleAstVisitorContext)).thenReturn((Object)nestedType2);
        EventType result = this.resolver.resolve(this.messageProcessorNode, inputEventType, this.typingMuleAstVisitor, this.typingMuleAstVisitorContext);
        Assert.assertEquals((Object)unionType, (Object)result);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)Mockito.any(UsesTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
    }

    @Test
    public void testIsPropagates() {
        Assert.assertFalse((boolean)this.resolver.isPropagates(this.messageProcessorNode));
    }

    @Test
    public void testIsSequential() {
        Assert.assertFalse((boolean)this.resolver.isSequential());
    }
}

