/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingContext;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingEnvironment;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorMatcher;
import org.mule.runtime.api.meta.model.error.ErrorModel;

public class ErrorHandlingEnvironmentTest {
    private ErrorHandlingEnvironment environment;
    @Mock
    private EventType mockEventType;
    @Mock
    private ErrorModel mockErrorModel;
    @Mock
    private ErrorMatcher mockErrorMatcher;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.environment = new ErrorHandlingEnvironment();
    }

    @Test
    public void testPushContext() {
        this.environment.pushContext("testId");
        Assert.assertNotNull((Object)this.environment.getContext());
    }

    @Test
    public void testPushContextWithEventType() {
        this.environment.pushContext("testId", this.mockEventType);
        Assert.assertNotNull((Object)this.environment.getContext());
    }

    @Test
    public void testPopContext() {
        this.environment.pushContext("testId1");
        this.environment.pushContext("testId2");
        this.environment.popContext();
        Assert.assertNotNull((Object)this.environment.getContext());
    }

    @Test
    public void testPopContextWithUnhandledErrors() {
        this.environment.pushContext("testId1");
        this.environment.pushContext("testId2");
        HashSet<ErrorModel> unhandledErrors = new HashSet<ErrorModel>();
        unhandledErrors.add(this.mockErrorModel);
        ErrorHandlingContext mockContext = (ErrorHandlingContext)Mockito.mock(ErrorHandlingContext.class);
        Mockito.when((Object)mockContext.getUnhandledErrors()).thenReturn(unhandledErrors);
        this.environment.popContext();
        this.environment.popContext();
        Assert.assertNotNull((Object)this.environment);
    }

    @Test
    public void testEnterErrorHandling() {
        this.environment.pushContext("testId");
        this.environment.enterErrorHandling();
        Assert.assertFalse((boolean)this.environment.getContext().isOpen());
    }

    @Test
    public void testThrowErrors() {
        this.environment.pushContext("testId");
        HashSet<ErrorModel> errorModels = new HashSet<ErrorModel>();
        errorModels.add(this.mockErrorModel);
        this.environment.throwErrors(errorModels);
        Assert.assertTrue((boolean)this.environment.getContext().getUnhandledErrors().contains(this.mockErrorModel));
    }

    @Test
    public void testHandleErrors() {
        this.environment.pushContext("testId");
        this.environment.handleErrors(this.mockErrorMatcher);
        Assert.assertNotNull((Object)this.environment.getContext());
    }

    @Test(expected=IllegalStateException.class)
    public void testFindOpenContextThrowsException() {
        this.environment.pushContext("testId");
        this.environment.enterErrorHandling();
        this.environment.throwErrors(new HashSet());
    }

    @Test
    public void testMultipleContexts() {
        this.environment.pushContext("testId1");
        this.environment.pushContext("testId2");
        this.environment.pushContext("testId3");
        Assert.assertNotNull((Object)this.environment.getContext());
    }
}

