/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.ComponentLocationAnnotation;
import org.mule.datasense.impl.model.annotations.HasDynamicMetadataAnnotation;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.annotators.BaseDynamicAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.ast.api.ComponentAst;

@RunWith(value=MockitoJUnitRunner.class)
public class BaseDynamicAnnotatorTest {
    private TestBaseDynamicAnnotator annotator;
    @Mock
    private MessageProcessorNode messageProcessorNode;
    @Mock
    private AnnotatingMuleAstVisitorContext context;
    @Mock
    private DataSenseProviderResolver dataSenseProviderResolver;
    @Mock
    private ComponentAst componentAst;
    @Mock
    private HasDynamicMetadataAnnotation hasDynamicMetadataAnnotation;
    @Mock
    private MuleFlowAnnotation muleFlowAnnotation;
    @Mock
    private ComponentLocationAnnotation componentLocationAnnotation;
    @Mock
    private DataSenseMetadataProvider dataSenseMetadataProvider;

    @Before
    public void setup() {
        this.annotator = new TestBaseDynamicAnnotator();
    }

    @Test
    public void testResolveComponentModelWithNoDynamicMetadata() {
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(HasDynamicMetadataAnnotation.class)).thenReturn(Optional.empty());
        Optional result = this.annotator.resolveComponentModel(this.messageProcessorNode, this.context, this.dataSenseProviderResolver, this.componentAst);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testResolveComponentModelWithIncompleteParameters() {
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(HasDynamicMetadataAnnotation.class)).thenReturn(Optional.of(this.hasDynamicMetadataAnnotation));
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"testParam");
        Mockito.when((Object)this.hasDynamicMetadataAnnotation.getIncompleteParameters()).thenReturn(Arrays.asList(parameterModel));
        Mockito.when((Object)this.context.getAstNotification()).thenReturn((Object)((AstNotification)Mockito.mock(AstNotification.class)));
        Optional result = this.annotator.resolveComponentModel(this.messageProcessorNode, this.context, this.dataSenseProviderResolver, this.componentAst);
        Assert.assertFalse((boolean)result.isPresent());
        ((AstNotification)Mockito.verify((Object)this.context.getAstNotification())).reportError((AstNodeLocation)Mockito.any(), (I18nMessage)Mockito.any());
    }

    @Test
    public void testResolveComponentModelWithFailedMetadataResolution() {
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(HasDynamicMetadataAnnotation.class)).thenReturn(Optional.of(this.hasDynamicMetadataAnnotation));
        Mockito.when((Object)this.hasDynamicMetadataAnnotation.getIncompleteParameters()).thenReturn(null);
        Mockito.when((Object)this.context.getAnnotation(MuleFlowAnnotation.class)).thenReturn(Optional.of(this.muleFlowAnnotation));
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(ComponentLocationAnnotation.class)).thenReturn(Optional.of(this.componentLocationAnnotation));
        Mockito.when((Object)this.dataSenseProviderResolver.getDataSenseProvider()).thenReturn((Object)((DataSenseProvider)Mockito.mock(DataSenseProvider.class)));
        Mockito.when((Object)this.dataSenseProviderResolver.getDataSenseProvider().getDataSenseMetadataProvider()).thenReturn(Optional.of(this.dataSenseMetadataProvider));
        Mockito.when((Object)this.context.getAstNotification()).thenReturn((Object)((AstNotification)Mockito.mock(AstNotification.class)));
        this.annotator.resolveComponentModel(this.messageProcessorNode, this.context, this.dataSenseProviderResolver, this.componentAst);
        Assert.assertNotNull((Object)((Object)this.annotator));
    }

    private class TestBaseDynamicAnnotator
    extends BaseDynamicAnnotator<ComponentModel> {
        private TestBaseDynamicAnnotator() {
        }

        protected MetadataResult<ComponentModel> resolveMetadata(MessageProcessorNode messageProcessorNode, DataSenseMetadataProvider dataSenseMetadataProvider, ComponentLocationAnnotation componentLocationAnnotation, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
            return new MetadataResult<ComponentModel>(){

                public ComponentModel get() {
                    return (ComponentModel)Mockito.mock(ComponentModel.class);
                }

                public boolean isSuccess() {
                    return false;
                }

                public List<MetadataFailure> getFailures() {
                    return Arrays.asList(MetadataFailure.Builder.newFailure((Exception)new RuntimeException("Test Exception")).onComponent());
                }
            };
        }
    }
}

