/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.datasense.impl.model.types.TypeAssignability;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.metadata.api.builder.AnyTypeBuilder;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BinaryTypeBuilder;
import org.mule.metadata.api.builder.BooleanTypeBuilder;
import org.mule.metadata.api.builder.DateTimeBuilder;
import org.mule.metadata.api.builder.LocalDateTimeTypeBuilder;
import org.mule.metadata.api.builder.LocalTimeTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.PeriodTypeBuilder;
import org.mule.metadata.api.builder.RegexTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TimeTypeBuilder;
import org.mule.metadata.api.builder.TimeZoneTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.MetadataType;

@RunWith(value=Parameterized.class)
public class TypeAssignableTest {
    private final MetadataType sourceType;
    private final MetadataType targetType;
    private final boolean expected;
    private final String name;

    public TypeAssignableTest(TypeBuilder sourceType, TypeBuilder targetType, boolean expected, String name) {
        this.sourceType = sourceType.build();
        this.targetType = targetType.build();
        this.expected = expected;
        this.name = name;
    }

    @Test
    public void assignableTest() {
        Assert.assertEquals((Object)this.expected, (Object)TypeAssignability.isAssignable((MetadataType)this.sourceType, (MetadataType)this.targetType, null));
    }

    private static List<Object[]> nothingIsAssignableToAnything() {
        String name = "nothingIsAssignableToAnything";
        return Arrays.asList({TypesHelper.getTypeBuilder().nothingType(), TypesHelper.getTypeBuilder().nothingType(), Boolean.TRUE, name}, {TypesHelper.getTypeBuilder().nothingType(), TypesHelper.getTypeBuilder().objectType(), Boolean.TRUE, name}, {TypesHelper.getTypeBuilder().nothingType(), TypesHelper.getTypeBuilder().arrayType().of().stringType(), Boolean.TRUE, name});
    }

    private static List<Object[]> unionIsAssignableIfAllUnionTypesAreAssignable() {
        String name = "unionIsAssignableIfAllUnionTypesAreAssignable";
        UnionTypeBuilder sourceUnionTypeBuilder1 = TypesHelper.getTypeBuilder().unionType();
        sourceUnionTypeBuilder1.of().numberType();
        UnionTypeBuilder sourceUnionTypeBuilder2 = TypesHelper.getTypeBuilder().unionType();
        sourceUnionTypeBuilder2.of().numberType();
        sourceUnionTypeBuilder2.of().stringType();
        UnionTypeBuilder sourceUnionTypeBuilder3 = TypesHelper.getTypeBuilder().unionType();
        sourceUnionTypeBuilder3.of().stringType();
        UnionTypeBuilder sourceUnionTypeBuilder4 = TypesHelper.getTypeBuilder().unionType();
        sourceUnionTypeBuilder4.of().stringType();
        sourceUnionTypeBuilder4.of().numberType();
        UnionTypeBuilder sourceUnionTypeBuilder5 = TypesHelper.getTypeBuilder().unionType();
        sourceUnionTypeBuilder5.of().stringType();
        return Arrays.asList({sourceUnionTypeBuilder1, sourceUnionTypeBuilder1, Boolean.TRUE, name}, {sourceUnionTypeBuilder1, sourceUnionTypeBuilder2, Boolean.TRUE, name}, {sourceUnionTypeBuilder2, sourceUnionTypeBuilder4, Boolean.TRUE, name}, {sourceUnionTypeBuilder5, TypesHelper.getTypeBuilder().stringType(), Boolean.TRUE, name}, {sourceUnionTypeBuilder1, sourceUnionTypeBuilder3, Boolean.FALSE, name}, {sourceUnionTypeBuilder2, sourceUnionTypeBuilder3, Boolean.FALSE, name});
    }

    private static List<Object[]> assignableToUnionMeansAssignableToAnyOfItsConstituentTypes() {
        String name = "assignableToUnionMeansAssignableToAnyOfItsConstituentTypes";
        StringTypeBuilder stringTypeBuilder = TypesHelper.getTypeBuilder().stringType();
        NumberTypeBuilder numberTypeBuilder = TypesHelper.getTypeBuilder().numberType();
        BooleanTypeBuilder booleanTypeBuilder = TypesHelper.getTypeBuilder().booleanType();
        UnionTypeBuilder unionTypeBuilder0 = TypesHelper.getTypeBuilder().unionType();
        unionTypeBuilder0.of().numberType();
        UnionTypeBuilder unionTypeBuilder1 = TypesHelper.getTypeBuilder().unionType();
        unionTypeBuilder1.of().numberType();
        unionTypeBuilder1.of().stringType();
        UnionTypeBuilder unionTypeBuilder2 = TypesHelper.getTypeBuilder().unionType();
        UnionTypeBuilder unionTypeBuilder21 = unionTypeBuilder2.of().unionType();
        unionTypeBuilder21.of().stringType();
        UnionTypeBuilder unionTypeBuilder22 = unionTypeBuilder2.of().unionType();
        unionTypeBuilder22.of().numberType();
        UnionTypeBuilder unionTypeBuilder3 = TypesHelper.getTypeBuilder().unionType();
        unionTypeBuilder3.of().numberType();
        unionTypeBuilder3.of().stringType();
        return Arrays.asList({numberTypeBuilder, unionTypeBuilder0, Boolean.TRUE, name}, {stringTypeBuilder, unionTypeBuilder0, Boolean.FALSE, name}, {stringTypeBuilder, unionTypeBuilder1, Boolean.TRUE, name}, {numberTypeBuilder, unionTypeBuilder1, Boolean.TRUE, name}, {booleanTypeBuilder, unionTypeBuilder1, Boolean.FALSE, name}, {stringTypeBuilder, unionTypeBuilder2, Boolean.TRUE, name}, {numberTypeBuilder, unionTypeBuilder2, Boolean.TRUE, name}, {unionTypeBuilder3, unionTypeBuilder2, Boolean.TRUE, name});
    }

    private static List<Object[]> objectIsAssignableToObjectIfAllRequiredTargetFieldsAreAssigned() {
        String name = "objectIsAssignableToObjectIfAllRequiredTargetFieldsAreAssigned";
        StringTypeBuilder stringTypeBuilder = TypesHelper.getTypeBuilder().stringType();
        NumberTypeBuilder numberTypeBuilder = TypesHelper.getTypeBuilder().numberType();
        BooleanTypeBuilder booleanTypeBuilder = TypesHelper.getTypeBuilder().booleanType();
        ObjectTypeBuilder objectTypeBuilder0 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder0.addField().key("field1").value((TypeBuilder)stringTypeBuilder);
        ObjectTypeBuilder objectTypeBuilder1 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder1.addField().key("field1").value((TypeBuilder)stringTypeBuilder).required(true);
        objectTypeBuilder1.addField().key("field2").value((TypeBuilder)numberTypeBuilder).required(true);
        ObjectTypeBuilder objectTypeBuilder2 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder2.addField().key("field1").value((TypeBuilder)booleanTypeBuilder).required(true);
        ObjectTypeBuilder objectTypeBuilder3 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder3.addField().key("field1").value((TypeBuilder)stringTypeBuilder);
        objectTypeBuilder3.addField().key("field2").value((TypeBuilder)numberTypeBuilder).required(true);
        ObjectTypeBuilder objectTypeBuilder31 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder31.addField().key("field1").value((TypeBuilder)stringTypeBuilder);
        objectTypeBuilder31.addField().key("field2").value((TypeBuilder)numberTypeBuilder).required(false);
        ObjectTypeBuilder objectTypeBuilder4 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder4.addField().key("field2").value((TypeBuilder)stringTypeBuilder).required(true);
        return Arrays.asList({objectTypeBuilder0, objectTypeBuilder0, Boolean.TRUE, name}, {objectTypeBuilder0, objectTypeBuilder1, Boolean.FALSE, name}, {objectTypeBuilder0, objectTypeBuilder2, Boolean.FALSE, name}, {objectTypeBuilder0, objectTypeBuilder3, Boolean.FALSE, name}, {objectTypeBuilder0, objectTypeBuilder31, Boolean.TRUE, name}, {objectTypeBuilder0, objectTypeBuilder4, Boolean.FALSE, name});
    }

    private static List<Object[]> objectIsAssignableOnlyToObject() {
        String name = "objectIsAssignableOnlyToObject";
        StringTypeBuilder stringTypeBuilder = TypesHelper.getTypeBuilder().stringType();
        ObjectTypeBuilder objectTypeBuilder0 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder0.addField().key("field1").value((TypeBuilder)stringTypeBuilder);
        return Arrays.asList({objectTypeBuilder0, stringTypeBuilder, Boolean.FALSE, "objectIsAssignableOnlyToObject"}, {stringTypeBuilder, objectTypeBuilder0, Boolean.FALSE, "objectIsAssignableOnlyToObject"});
    }

    private static List<Object[]> arrayIsAssignableToArrayIfTheirItemsAreAssignable() {
        String name = "arrayIsAssignableToArrayIfTheirItemsAreAssignable";
        StringTypeBuilder stringTypeBuilder = TypesHelper.getTypeBuilder().stringType();
        NumberTypeBuilder numberTypeBuilder = TypesHelper.getTypeBuilder().numberType();
        BooleanTypeBuilder booleanTypeBuilder = TypesHelper.getTypeBuilder().booleanType();
        UnionTypeBuilder unionTypeBuilder0 = TypesHelper.getTypeBuilder().unionType();
        unionTypeBuilder0.of().numberType();
        ObjectTypeBuilder objectTypeBuilder0 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder0.addField().key("field1").value((TypeBuilder)stringTypeBuilder).required(true);
        ObjectTypeBuilder objectTypeBuilder1 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder1.addField().key("field1").value((TypeBuilder)stringTypeBuilder).required(true);
        objectTypeBuilder1.addField().key("field2").value((TypeBuilder)stringTypeBuilder).required(false);
        ObjectTypeBuilder objectTypeBuilder2 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder2.addField().key("field1").value((TypeBuilder)stringTypeBuilder).required(true);
        objectTypeBuilder2.addField().key("field2").value((TypeBuilder)stringTypeBuilder).required(true);
        ArrayTypeBuilder arrayTypeBuilder0 = TypesHelper.getTypeBuilder().arrayType();
        arrayTypeBuilder0.of((TypeBuilder)numberTypeBuilder);
        ArrayTypeBuilder arrayTypeBuilder1 = TypesHelper.getTypeBuilder().arrayType();
        arrayTypeBuilder1.of((TypeBuilder)stringTypeBuilder);
        ArrayTypeBuilder arrayTypeBuilder21 = TypesHelper.getTypeBuilder().arrayType();
        arrayTypeBuilder21.of((TypeBuilder)objectTypeBuilder0);
        ArrayTypeBuilder arrayTypeBuilder22 = TypesHelper.getTypeBuilder().arrayType();
        arrayTypeBuilder22.of((TypeBuilder)objectTypeBuilder1);
        ArrayTypeBuilder arrayTypeBuilder23 = TypesHelper.getTypeBuilder().arrayType();
        arrayTypeBuilder23.of((TypeBuilder)objectTypeBuilder2);
        return Arrays.asList({arrayTypeBuilder0, arrayTypeBuilder0, Boolean.TRUE, name}, {arrayTypeBuilder0, arrayTypeBuilder1, Boolean.FALSE, name}, {arrayTypeBuilder21, arrayTypeBuilder22, Boolean.TRUE, name}, {arrayTypeBuilder21, arrayTypeBuilder23, Boolean.FALSE, name});
    }

    private static List<Object[]> arrayIsAssignableOnlyToArray() {
        String name = "arrayIsAssignableOnlyToArray";
        StringTypeBuilder stringTypeBuilder = TypesHelper.getTypeBuilder().stringType();
        ObjectTypeBuilder objectTypeBuilder2 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder2.addField().key("field1").value((TypeBuilder)stringTypeBuilder).required(true);
        objectTypeBuilder2.addField().key("field2").value((TypeBuilder)stringTypeBuilder).required(true);
        ArrayTypeBuilder arrayTypeBuilder23 = TypesHelper.getTypeBuilder().arrayType();
        arrayTypeBuilder23.of((TypeBuilder)objectTypeBuilder2);
        ObjectTypeBuilder objectTypeBuilder0 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder0.addField().key("field1").value((TypeBuilder)stringTypeBuilder);
        return Arrays.asList({objectTypeBuilder0, arrayTypeBuilder23, Boolean.FALSE, name}, {stringTypeBuilder, arrayTypeBuilder23, Boolean.FALSE, name});
    }

    private static List<Object[]> primitiveOnlyAssignableToSamePrimitive() {
        String name = "primitiveOnlyAssignableToSamePrimitive";
        StringTypeBuilder stringTypeBuilder = TypesHelper.getTypeBuilder().stringType();
        NumberTypeBuilder numberTypeBuilder = TypesHelper.getTypeBuilder().numberType();
        BooleanTypeBuilder booleanTypeBuilder = TypesHelper.getTypeBuilder().booleanType();
        DateTimeBuilder dateTimeTypeBuilder = TypesHelper.getTypeBuilder().dateTimeType();
        LocalDateTimeTypeBuilder localDateTimeTypeBuilder = TypesHelper.getTypeBuilder().localDateTimeType();
        LocalTimeTypeBuilder localTimeTypeBuilder = TypesHelper.getTypeBuilder().localTimeType();
        TimeTypeBuilder timeTypeBuilder = TypesHelper.getTypeBuilder().timeType();
        TimeZoneTypeBuilder timeZoneTypeBuilder = TypesHelper.getTypeBuilder().timeZoneType();
        PeriodTypeBuilder periodTypeBuilder = TypesHelper.getTypeBuilder().periodType();
        BinaryTypeBuilder binaryTypeBuilder = TypesHelper.getTypeBuilder().binaryType();
        RegexTypeBuilder regexTypeBuilder = TypesHelper.getTypeBuilder().regexType();
        return Arrays.asList({stringTypeBuilder, stringTypeBuilder, Boolean.TRUE, name}, {numberTypeBuilder, numberTypeBuilder, Boolean.TRUE, name}, {booleanTypeBuilder, booleanTypeBuilder, Boolean.TRUE, name}, {booleanTypeBuilder, numberTypeBuilder, Boolean.FALSE, name}, {stringTypeBuilder, booleanTypeBuilder, Boolean.FALSE, name}, {dateTimeTypeBuilder, dateTimeTypeBuilder, Boolean.TRUE, name}, {localDateTimeTypeBuilder, localDateTimeTypeBuilder, Boolean.TRUE, name}, {localTimeTypeBuilder, localTimeTypeBuilder, Boolean.TRUE, name}, {timeTypeBuilder, timeTypeBuilder, Boolean.TRUE, name}, {timeZoneTypeBuilder, timeZoneTypeBuilder, Boolean.TRUE, name}, {periodTypeBuilder, periodTypeBuilder, Boolean.TRUE, name}, {binaryTypeBuilder, binaryTypeBuilder, Boolean.TRUE, name}, {regexTypeBuilder, regexTypeBuilder, Boolean.TRUE, name});
    }

    private static List<Object[]> anythingIsAssignableToAnything() {
        String name = "anythingIsAssignableToAnything";
        StringTypeBuilder stringTypeBuilder = TypesHelper.getTypeBuilder().stringType();
        NumberTypeBuilder numberTypeBuilder = TypesHelper.getTypeBuilder().numberType();
        BooleanTypeBuilder booleanTypeBuilder = TypesHelper.getTypeBuilder().booleanType();
        UnionTypeBuilder unionTypeBuilder0 = TypesHelper.getTypeBuilder().unionType();
        unionTypeBuilder0.of().numberType();
        ObjectTypeBuilder objectTypeBuilder0 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder0.addField().key("field1").value((TypeBuilder)stringTypeBuilder).required(true);
        AnyTypeBuilder anyTypeBuilder = TypesHelper.getTypeBuilder().anyType();
        return Arrays.asList({anyTypeBuilder, anyTypeBuilder, Boolean.TRUE, name}, {stringTypeBuilder, anyTypeBuilder, Boolean.TRUE, name}, {numberTypeBuilder, anyTypeBuilder, Boolean.TRUE, name}, {booleanTypeBuilder, anyTypeBuilder, Boolean.TRUE, name}, {unionTypeBuilder0, anyTypeBuilder, Boolean.TRUE, name}, {objectTypeBuilder0, anyTypeBuilder, Boolean.TRUE, name});
    }

    @Parameterized.Parameters(name="{3}-{index}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.addAll(TypeAssignableTest.nothingIsAssignableToAnything());
        parameters.addAll(TypeAssignableTest.unionIsAssignableIfAllUnionTypesAreAssignable());
        parameters.addAll(TypeAssignableTest.assignableToUnionMeansAssignableToAnyOfItsConstituentTypes());
        parameters.addAll(TypeAssignableTest.objectIsAssignableToObjectIfAllRequiredTargetFieldsAreAssigned());
        parameters.addAll(TypeAssignableTest.objectIsAssignableOnlyToObject());
        parameters.addAll(TypeAssignableTest.arrayIsAssignableToArrayIfTheirItemsAreAssignable());
        parameters.addAll(TypeAssignableTest.arrayIsAssignableOnlyToArray());
        parameters.addAll(TypeAssignableTest.primitiveOnlyAssignableToSamePrimitive());
        parameters.addAll(TypeAssignableTest.anythingIsAssignableToAnything());
        return parameters;
    }
}

