/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing;

import java.util.Arrays;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.annotations.ThrowsErrorsTypeAnnotation;
import org.mule.datasense.impl.model.annotations.TypesResolvedAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.ast.VisitorContextAnnotation;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingContext;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingEnvironment;
import org.mule.datasense.impl.util.TreeLogSupport;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.ast.api.ComponentAst;

public class TypingMuleAstVisitorTest {
    private TypingMuleAstVisitor visitor;
    private TypeResolverRegistry mockTypeResolverRegistry;
    private ExpressionLanguageMetadataService mockExpressionLanguageMetadataService;
    private TypingMuleAstVisitorContext mockVisitorContext;

    @Before
    public void setUp() {
        this.mockTypeResolverRegistry = (TypeResolverRegistry)Mockito.mock(TypeResolverRegistry.class);
        this.mockExpressionLanguageMetadataService = (ExpressionLanguageMetadataService)Mockito.mock(ExpressionLanguageMetadataService.class);
        this.visitor = new TypingMuleAstVisitor(this.mockTypeResolverRegistry, this.mockExpressionLanguageMetadataService);
        this.mockVisitorContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
    }

    @Test
    public void testVisitMuleApplicationNode() {
        MuleApplicationNode mockMuleAppNode = (MuleApplicationNode)Mockito.mock(MuleApplicationNode.class);
        MuleFlowNode mockFlowNode1 = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        MuleFlowNode mockFlowNode2 = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        Mockito.when((Object)mockMuleAppNode.getName()).thenReturn((Object)"TestApp");
        Mockito.when((Object)mockMuleAppNode.getMuleFlowNodes()).thenReturn(Arrays.asList(mockFlowNode1, mockFlowNode2).stream());
        Mockito.when((Object)this.mockVisitorContext.logger()).thenReturn((Object)((TreeLogSupport)Mockito.mock(TreeLogSupport.class)));
        this.visitor.visit(mockMuleAppNode, this.mockVisitorContext);
        ((TypingMuleAstVisitorContext)Mockito.verify((Object)this.mockVisitorContext)).annotate((VisitorContextAnnotation)((MuleApplicationAnnotation)Mockito.any(MuleApplicationAnnotation.class)));
        ((MuleFlowNode)Mockito.verify((Object)mockFlowNode1)).accept((AstNodeVisitor)this.visitor, (Object)this.mockVisitorContext);
        ((MuleFlowNode)Mockito.verify((Object)mockFlowNode2)).accept((AstNodeVisitor)this.visitor, (Object)this.mockVisitorContext);
        ((TypingMuleAstVisitorContext)Mockito.verify((Object)this.mockVisitorContext)).deannotate(MuleApplicationAnnotation.class);
    }

    @Test
    public void testVisitMuleFlowNodeWithExistingAnnotation() {
        MuleFlowNode mockFlowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        TypesResolvedAnnotation mockAnnotation = (TypesResolvedAnnotation)Mockito.mock(TypesResolvedAnnotation.class);
        EventType mockEventType = (EventType)Mockito.mock(EventType.class);
        Mockito.when((Object)mockFlowNode.getAnnotation(TypesResolvedAnnotation.class)).thenReturn(Optional.of(mockAnnotation));
        Mockito.when((Object)mockAnnotation.getResult()).thenReturn(Optional.of(mockEventType));
        Object result = this.visitor.visit(mockFlowNode, this.mockVisitorContext);
        Assert.assertEquals((Object)mockEventType, (Object)result);
    }

    @Test
    public void testVisitMuleFlowNodeWithoutExistingAnnotation() {
        MuleFlowNode mockFlowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        MessageProcessorNode mockRootProcessor = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        EventType mockEventType = (EventType)Mockito.mock(EventType.class);
        Mockito.when((Object)mockFlowNode.getAnnotation(TypesResolvedAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)mockFlowNode.getName()).thenReturn((Object)"TestFlow");
        Mockito.when((Object)mockFlowNode.getComponentModel()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        Mockito.when((Object)mockFlowNode.getRootMessageProcessorNode()).thenReturn(Optional.of(mockRootProcessor));
        Mockito.when((Object)mockRootProcessor.accept((AstNodeVisitor)this.visitor, (Object)this.mockVisitorContext)).thenReturn((Object)mockEventType);
        Mockito.when((Object)this.mockVisitorContext.logger()).thenReturn((Object)((TreeLogSupport)Mockito.mock(TreeLogSupport.class)));
        Mockito.when((Object)this.mockVisitorContext.getErrorHandlingEnvironment()).thenReturn((Object)((ErrorHandlingEnvironment)Mockito.mock(ErrorHandlingEnvironment.class)));
        Mockito.when((Object)this.mockVisitorContext.getErrorHandlingEnvironment().getContext()).thenReturn((Object)((ErrorHandlingContext)Mockito.mock(ErrorHandlingContext.class)));
        Object result = this.visitor.visit(mockFlowNode, this.mockVisitorContext);
        Assert.assertEquals((Object)mockEventType, (Object)result);
        ((MuleFlowNode)Mockito.verify((Object)mockFlowNode)).annotate((AstNodeAnnotation)((TypesResolvedAnnotation)Mockito.any(TypesResolvedAnnotation.class)));
        ((MuleFlowNode)Mockito.verify((Object)mockFlowNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
        ((MuleFlowNode)Mockito.verify((Object)mockFlowNode)).reannotate((AstNodeAnnotation)((TypesResolvedAnnotation)Mockito.any(TypesResolvedAnnotation.class)));
        ((MuleFlowNode)Mockito.verify((Object)mockFlowNode)).annotate((AstNodeAnnotation)((ThrowsErrorsTypeAnnotation)Mockito.any(ThrowsErrorsTypeAnnotation.class)));
    }

    @Test
    public void testVisitMessageProcessorNode() {
        MessageProcessorNode mockProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        ComponentIdentifier mockIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        Mockito.when((Object)mockProcessorNode.getComponentIdentifier()).thenReturn((Object)mockIdentifier);
        Mockito.when((Object)mockIdentifier.toString()).thenReturn((Object)"TestProcessor");
        Mockito.when((Object)this.mockVisitorContext.logger()).thenReturn((Object)((TreeLogSupport)Mockito.mock(TreeLogSupport.class)));
        Mockito.when((Object)this.mockVisitorContext.getTypeResolverRegistry()).thenReturn((Object)this.mockTypeResolverRegistry);
        Mockito.when((Object)this.mockTypeResolverRegistry.get((ComponentIdentifier)Mockito.any())).thenReturn(Optional.empty());
        Object result = this.visitor.visit(mockProcessorNode, this.mockVisitorContext);
        Assert.assertTrue((boolean)(result instanceof EventType));
    }

    @Test
    public void testResolveTypeWithNullAstNode() {
        EventType inputEventType = (EventType)Mockito.mock(EventType.class);
        AstNotification mockNotification = (AstNotification)Mockito.mock(AstNotification.class);
        EventType result = this.visitor.resolveType(null, inputEventType, mockNotification);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof EventType));
    }

    @Test
    public void testResolveTypeWithValidAstNode() {
        AstNode mockAstNode = (AstNode)Mockito.mock(AstNode.class);
        EventType inputEventType = (EventType)Mockito.mock(EventType.class);
        AstNotification mockNotification = (AstNotification)Mockito.mock(AstNotification.class);
        EventType expectedResult = (EventType)Mockito.mock(EventType.class);
        Mockito.when((Object)mockAstNode.accept((AstNodeVisitor)Mockito.eq((Object)this.visitor), (Object)((TypingMuleAstVisitorContext)Mockito.any(TypingMuleAstVisitorContext.class)))).thenReturn((Object)expectedResult);
        EventType result = this.visitor.resolveType(mockAstNode, inputEventType, mockNotification);
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }
}

