/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.event;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.event.Expr;
import org.mule.datasense.impl.model.event.ExprBuilder;
import org.mule.datasense.impl.model.event.LiteralTypeExpr;
import org.mule.datasense.impl.model.event.LiteralTypeExprBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;

public class LiteralTypeExprBuilderTest {
    @Test
    public void testConstructorWithValidType() {
        MetadataType metadataType = (MetadataType)Mockito.mock(StringType.class);
        LiteralTypeExprBuilder builder = new LiteralTypeExprBuilder(metadataType);
        Assert.assertNotNull((String)"LiteralTypeExprBuilder instance should not be null", (Object)builder);
    }

    @Test
    public void testMimeTypeMethodReturnsSameBuilderInstance() {
        MetadataType metadataType = (MetadataType)Mockito.mock(StringType.class);
        LiteralTypeExprBuilder builder = new LiteralTypeExprBuilder(metadataType);
        ExprBuilder result = builder.mimeType("application/json");
        Assert.assertNotNull((String)"mimeType method should return a non-null builder", (Object)result);
        Assert.assertSame((String)"mimeType method should return the same instance", (Object)builder, (Object)result);
    }

    @Test
    public void testBuildReturnsLiteralTypeExprWithSameMetadataType() {
        MetadataType metadataType = (MetadataType)Mockito.mock(StringType.class);
        LiteralTypeExprBuilder builder = new LiteralTypeExprBuilder(metadataType);
        Expr result = builder.build();
        Assert.assertNotNull((String)"build method should return a non-null Expr", (Object)result);
        Assert.assertTrue((String)"build method should return a LiteralTypeExpr", (boolean)(result instanceof LiteralTypeExpr));
        LiteralTypeExpr literalExpr = (LiteralTypeExpr)result;
        MetadataType resolvedType = literalExpr.resolveType(null, null);
        Assert.assertEquals((String)"Resolved type should be the same as the one provided to the builder", (Object)metadataType, (Object)resolvedType);
    }
}

