/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.event;

import org.junit.Assert;
import org.junit.Test;
import org.mule.datasense.impl.model.event.Expr;
import org.mule.datasense.impl.model.event.SimpleExpr;
import org.mule.datasense.impl.model.event.SimpleExprBuilder;

public class SimpleExprBuilderTest {
    @Test
    public void testBuildWithExpressionOnly() {
        SimpleExprBuilder builder = new SimpleExprBuilder("payload");
        Expr expr = builder.build();
        Assert.assertTrue((boolean)(expr instanceof SimpleExpr));
    }

    @Test
    public void testBuildWithExpressionAndMimeType() {
        SimpleExprBuilder builder = new SimpleExprBuilder("payload");
        builder.mimeType("application/json");
        Expr expr = builder.build();
        Assert.assertTrue((boolean)(expr instanceof SimpleExpr));
    }

    @Test
    public void testMimeTypeChaining() {
        SimpleExprBuilder builder = new SimpleExprBuilder("payload");
        SimpleExprBuilder returnedBuilder = builder.mimeType("text/plain");
        Assert.assertSame((Object)builder, (Object)returnedBuilder);
    }

    @Test
    public void testMultipleMimeTypeSettings() {
        SimpleExprBuilder builder = new SimpleExprBuilder("payload");
        builder.mimeType("text/plain").mimeType("application/xml");
        Assert.assertNotNull((Object)builder.build());
    }

    @Test
    public void testBuildWithEmptyExpression() {
        SimpleExprBuilder builder = new SimpleExprBuilder("");
        Assert.assertNotNull((Object)builder.build());
    }

    @Test
    public void testMimeTypeWithEmptyString() {
        SimpleExprBuilder builder = new SimpleExprBuilder("payload");
        builder.mimeType("");
        Assert.assertNotNull((Object)builder.build());
    }

    @Test
    public void testMimeTypeWithNull() {
        SimpleExprBuilder builder = new SimpleExprBuilder("payload");
        builder.mimeType(null);
        Assert.assertNotNull((Object)builder.build());
    }
}

