/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.typing.MessageProcessorScope;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.datasense.impl.util.ExpressionLanguageMetadataServiceUtils;
import org.mule.datasense.impl.util.matchers.MetadataTypeMatcher;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
abstract class BaseTypeResolverTestOld {
    static final transient Logger logger = LoggerFactory.getLogger(BaseTypeResolverTestOld.class);
    private final String name;
    private final Supplier<MuleEventMetadataTypeBuilder> inputMuleEventMetadataTypeBuilderSupplier;
    private final String usesMetadataTypeData;
    private final String definesMetadataTypeData;
    private final String resultMetadataTypeData;
    private final MessageProcessorNode messageProcessorNode;
    private final TypeResolver typeResolver;
    private final TypeResolverRegistry typeResolverRegistry;
    private final String componentIdentifier;
    private final Supplier<ComponentAst> componentModel;
    private final Supplier<List<MessageProcessorNode>> messageProcessorNodeList;
    private final Supplier<TypingMuleAstVisitor> typingMuleAstVisitor;

    public BaseTypeResolverTestOld(String name, String componentIdentifier, Supplier<MuleEventMetadataTypeBuilder> inputMuleEventMetadataTypeBuilderSupplier, String usesMetadataTypeData, String definesMetadataTypeData, String resultMetadataTypeData) {
        this(name, componentIdentifier, inputMuleEventMetadataTypeBuilderSupplier, null, null, null, null, usesMetadataTypeData, definesMetadataTypeData, resultMetadataTypeData);
    }

    public BaseTypeResolverTestOld(String name, String componentIdentifier, Supplier<MuleEventMetadataTypeBuilder> inputMuleEventMetadataTypeBuilderSupplier, Supplier<ComponentAst> componentModel, Supplier<List<MessageProcessorNode>> messageProcessorNodeList, Supplier<TypingMuleAstVisitor> typingMuleAstVisitor, TypeResolver typeResolver, String usesMetadataTypeData, String definesMetadataTypeData, String resultMetadataTypeData) {
        this.componentIdentifier = componentIdentifier;
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(inputMuleEventMetadataTypeBuilderSupplier);
        Preconditions.checkNotNull((Object)usesMetadataTypeData);
        Preconditions.checkNotNull((Object)definesMetadataTypeData);
        Preconditions.checkNotNull((Object)resultMetadataTypeData);
        this.name = name;
        this.inputMuleEventMetadataTypeBuilderSupplier = inputMuleEventMetadataTypeBuilderSupplier;
        this.usesMetadataTypeData = usesMetadataTypeData;
        this.definesMetadataTypeData = definesMetadataTypeData;
        this.resultMetadataTypeData = resultMetadataTypeData;
        this.typeResolverRegistry = new TypeResolverRegistry();
        this.componentModel = componentModel;
        this.messageProcessorNodeList = messageProcessorNodeList;
        this.typingMuleAstVisitor = Optional.ofNullable(typingMuleAstVisitor).orElse(() -> new TypingMuleAstVisitor(this.typeResolverRegistry, ExpressionLanguageMetadataServiceUtils.createExpressionLanguageMetadataService()));
        this.messageProcessorNode = new MessageProcessorNode(ComponentIdentifier.buildFromStringRepresentation((String)componentIdentifier), componentModel.get(), Optional.ofNullable(messageProcessorNodeList.get()).orElse(Collections.emptyList()));
        this.typeResolver = this.createTypeResolver().orElse(typeResolver);
    }

    public Optional<TypeResolver> createTypeResolver() {
        return Optional.empty();
    }

    private void assertMetadataType(String label, EventType eventType, String expectedMetadataTypeData) {
        MuleEventMetadataType actualMetadataType = TypeUtils.asMuleEventMetadataType((EventType)eventType).build();
        Assert.assertThat((String)String.format("Assertion failed for %s metadata type.", label), (Object)actualMetadataType, (Matcher)new MetadataTypeMatcher.IsAs(expectedMetadataTypeData));
    }

    @Test
    public void test() {
        TypingMuleAstVisitorContext typingMuleAstVisitorContext = new TypingMuleAstVisitorContext(this.typeResolverRegistry, new AstNotification(), ExpressionLanguageMetadataServiceUtils.createExpressionLanguageMetadataService());
        EventType inputEventType = TypeUtils.asEventType((MuleEventMetadataType)this.inputMuleEventMetadataTypeBuilderSupplier.get().build());
        typingMuleAstVisitorContext.getTypingEnvironment().push(new MessageProcessorScope(inputEventType));
        EventType resultEventType = this.typeResolver.resolveTypes(this.messageProcessorNode, this.typingMuleAstVisitor.get(), typingMuleAstVisitorContext);
        UsesTypeAnnotation usesTypeAnnotation = (UsesTypeAnnotation)this.messageProcessorNode.getAnnotation(UsesTypeAnnotation.class).orElseThrow(AssertionError::new);
        EventType usesEventType = usesTypeAnnotation.getUsesEventType();
        this.assertMetadataType("uses", usesEventType, this.usesMetadataTypeData);
        DefinesTypeAnnotation definesTypeAnnotation = (DefinesTypeAnnotation)this.messageProcessorNode.getAnnotation(DefinesTypeAnnotation.class).orElseThrow(AssertionError::new);
        EventType definesEventType = definesTypeAnnotation.getDefinesEventType();
        this.assertMetadataType("defines", definesEventType, this.definesMetadataTypeData);
        this.assertMetadataType("result", resultEventType, this.resultMetadataTypeData);
    }
}

