/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.event;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.event.DefElemValueExpr;
import org.mule.datasense.impl.model.event.DefElemValueExprBuilder;
import org.mule.datasense.impl.model.event.DefVariable;
import org.mule.datasense.impl.model.event.DefVariableBuilder;

public class DefVariableBuilderTest {
    private DefVariableBuilder builder;
    private DefElemValueExprBuilder mockValueBuilder;

    @Before
    public void setUp() {
        this.mockValueBuilder = (DefElemValueExprBuilder)Mockito.mock(DefElemValueExprBuilder.class);
    }

    @Test
    public void testConstructorAndGetName() {
        this.builder = new DefVariableBuilder("testVar");
        Assert.assertEquals((Object)"testVar", (Object)this.builder.getName());
    }

    @Test
    public void testValueMethod() {
        this.builder = new DefVariableBuilder("testVar");
        DefVariableBuilder result = this.builder.value(this.mockValueBuilder);
        Assert.assertSame((Object)this.builder, (Object)result);
    }

    @Test
    public void testBuildWithValidName() {
        this.builder = new DefVariableBuilder("validName");
        this.builder.value(this.mockValueBuilder);
        DefElemValueExpr mockValue = (DefElemValueExpr)Mockito.mock(DefElemValueExpr.class);
        Mockito.when((Object)this.mockValueBuilder.build()).thenReturn((Object)mockValue);
        Optional result = this.builder.build();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertTrue((boolean)(result.get() instanceof DefVariable));
        DefVariable defVariable = (DefVariable)result.get();
        Assert.assertNotNull((Object)defVariable);
    }

    @Test
    public void testBuildWithNullName() {
        this.builder = new DefVariableBuilder(null);
        this.builder.value(this.mockValueBuilder);
        Optional result = this.builder.build();
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testBuildWithEmptyName() {
        this.builder = new DefVariableBuilder("");
        this.builder.value(this.mockValueBuilder);
        Optional result = this.builder.build();
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testBuildMultipleTimes() {
        this.builder = new DefVariableBuilder("testVar");
        this.builder.value(this.mockValueBuilder);
        DefElemValueExpr mockValue = (DefElemValueExpr)Mockito.mock(DefElemValueExpr.class);
        Mockito.when((Object)this.mockValueBuilder.build()).thenReturn((Object)mockValue);
        Optional result1 = this.builder.build();
        Optional result2 = this.builder.build();
        Assert.assertTrue((boolean)result1.isPresent());
        Assert.assertTrue((boolean)result2.isPresent());
        Assert.assertNotSame(result1.get(), result2.get());
    }
}

