/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.model.types.TypeAssignability;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NothingType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.UnionType;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class TypeAssignabilityTest {
    @Test
    public void testAnyTypeIsAssignableToAnyType() {
        AnyType sourceType = (AnyType)Mockito.mock(AnyType.class);
        AnyType targetType = (AnyType)Mockito.mock(AnyType.class);
        Assert.assertTrue((boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testNothingTypeIsAssignableToAnyType() {
        NothingType sourceType = (NothingType)Mockito.mock(NothingType.class);
        AnyType targetType = (AnyType)Mockito.mock(AnyType.class);
        Assert.assertTrue((boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testStringTypeIsAssignableToStringType() {
        StringType sourceType = (StringType)Mockito.mock(StringType.class);
        StringType targetType = (StringType)Mockito.mock(StringType.class);
        Assert.assertTrue((boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testStringTypeIsNotAssignableToBooleanType() {
        StringType sourceType = (StringType)Mockito.mock(StringType.class);
        BooleanType targetType = (BooleanType)Mockito.mock(BooleanType.class);
        Assert.assertFalse((boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testNumberTypeIsAssignableToNumberType() {
        NumberType sourceType = (NumberType)Mockito.mock(NumberType.class);
        NumberType targetType = (NumberType)Mockito.mock(NumberType.class);
        Assert.assertTrue((boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testBooleanTypeIsAssignableToBooleanType() {
        BooleanType sourceType = (BooleanType)Mockito.mock(BooleanType.class);
        BooleanType targetType = (BooleanType)Mockito.mock(BooleanType.class);
        Assert.assertTrue((boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testDateTimeTypeIsAssignableToDateTimeType() {
        DateTimeType sourceType = (DateTimeType)Mockito.mock(DateTimeType.class);
        DateTimeType targetType = (DateTimeType)Mockito.mock(DateTimeType.class);
        Assert.assertTrue((boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testBinaryTypeIsAssignableToBinaryType() {
        BinaryType sourceType = (BinaryType)Mockito.mock(BinaryType.class);
        BinaryType targetType = (BinaryType)Mockito.mock(BinaryType.class);
        Assert.assertTrue((boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testArrayTypeIsAssignableToCompatibleArrayType() {
        ArrayType sourceType = (ArrayType)Mockito.mock(ArrayType.class);
        ArrayType targetType = (ArrayType)Mockito.mock(ArrayType.class);
        StringType sourceItemType = (StringType)Mockito.mock(StringType.class);
        StringType targetItemType = (StringType)Mockito.mock(StringType.class);
        Mockito.when((Object)sourceType.getType()).thenReturn((Object)sourceItemType);
        Mockito.when((Object)targetType.getType()).thenReturn((Object)targetItemType);
        Assert.assertTrue((boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testArrayTypeIsNotAssignableToIncompatibleArrayType() {
        ArrayType sourceType = (ArrayType)Mockito.mock(ArrayType.class);
        ArrayType targetType = (ArrayType)Mockito.mock(ArrayType.class);
        StringType sourceItemType = (StringType)Mockito.mock(StringType.class);
        NumberType targetItemType = (NumberType)Mockito.mock(NumberType.class);
        Mockito.when((Object)sourceType.getType()).thenReturn((Object)sourceItemType);
        Mockito.when((Object)targetType.getType()).thenReturn((Object)targetItemType);
        Assert.assertFalse((boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testUnionTypeIsAssignableWhenAllTypesAreAssignable() {
        UnionType sourceType = (UnionType)Mockito.mock(UnionType.class);
        StringType targetType = (StringType)Mockito.mock(StringType.class);
        StringType unionMember1 = (StringType)Mockito.mock(StringType.class);
        StringType unionMember2 = (StringType)Mockito.mock(StringType.class);
        Mockito.when((Object)sourceType.getTypes()).thenReturn(Arrays.asList(unionMember1, unionMember2));
        Assert.assertTrue((boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testSourceIsAssignableToUnionTypeTargetWhenCompatibleWithAnyMember() {
        StringType sourceType = (StringType)Mockito.mock(StringType.class);
        UnionType targetType = (UnionType)Mockito.mock(UnionType.class);
        NumberType unionMember1 = (NumberType)Mockito.mock(NumberType.class);
        StringType unionMember2 = (StringType)Mockito.mock(StringType.class);
        Mockito.when((Object)targetType.getTypes()).thenReturn(Arrays.asList(unionMember1, unionMember2));
        Assert.assertTrue((boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testObjectTypeFieldRequirementChecks() {
        ObjectType sourceType = (ObjectType)Mockito.mock(ObjectType.class);
        ObjectType targetType = (ObjectType)Mockito.mock(ObjectType.class);
        ObjectFieldType sourceField = (ObjectFieldType)Mockito.mock(ObjectFieldType.class);
        ObjectFieldType targetField = (ObjectFieldType)Mockito.mock(ObjectFieldType.class);
        ObjectKeyType sourceKey = (ObjectKeyType)Mockito.mock(ObjectKeyType.class);
        ObjectKeyType targetKey = (ObjectKeyType)Mockito.mock(ObjectKeyType.class);
        StringType sourceValue = (StringType)Mockito.mock(StringType.class);
        StringType targetValue = (StringType)Mockito.mock(StringType.class);
        QName fieldName = new QName("field");
        Mockito.when((Object)sourceKey.getName()).thenReturn((Object)fieldName);
        Mockito.when((Object)targetKey.getName()).thenReturn((Object)fieldName);
        Mockito.when((Object)sourceKey.getAttributes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)targetKey.getAttributes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)sourceField.getKey()).thenReturn((Object)sourceKey);
        Mockito.when((Object)targetField.getKey()).thenReturn((Object)targetKey);
        Mockito.when((Object)sourceField.getValue()).thenReturn((Object)sourceValue);
        Mockito.when((Object)targetField.getValue()).thenReturn((Object)targetValue);
        Mockito.when((Object)targetField.isRequired()).thenReturn((Object)true);
        Mockito.when((Object)sourceField.isRequired()).thenReturn((Object)true);
        Set<ObjectFieldType> sourceFields = Collections.singleton(sourceField);
        Set<ObjectFieldType> targetFields = Collections.singleton(targetField);
        Mockito.when((Object)sourceType.getFields()).thenReturn(sourceFields);
        Mockito.when((Object)targetType.getFields()).thenReturn(targetFields);
        Mockito.when((Object)sourceType.getMetadataFormat()).thenReturn((Object)MetadataFormat.JAVA);
        Mockito.when((Object)targetType.getMetadataFormat()).thenReturn((Object)MetadataFormat.JAVA);
        Mockito.when((Object)sourceType.getAnnotation(TypeIdAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)targetType.getAnnotation(TypeIdAnnotation.class)).thenReturn(Optional.empty());
        Assert.assertTrue((boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testIsEqualReturnsTrueWhenTypesAreAssignableInBothDirections() {
        StringType sourceType = (StringType)Mockito.mock(StringType.class);
        StringType targetType = (StringType)Mockito.mock(StringType.class);
        Assert.assertTrue((boolean)TypeAssignability.isEqual((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testIsEqualReturnsFalseWhenTypesAreNotAssignableInBothDirections() {
        StringType sourceType = (StringType)Mockito.mock(StringType.class);
        NumberType targetType = (NumberType)Mockito.mock(NumberType.class);
        Assert.assertFalse((boolean)TypeAssignability.isEqual((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testObjectTypeWithTypeIdAnnotation() {
        ObjectType sourceType = (ObjectType)Mockito.mock(ObjectType.class);
        ObjectType targetType = (ObjectType)Mockito.mock(ObjectType.class);
        TypeIdAnnotation sourceTypeIdAnnotation = (TypeIdAnnotation)Mockito.mock(TypeIdAnnotation.class);
        TypeIdAnnotation targetTypeIdAnnotation = (TypeIdAnnotation)Mockito.mock(TypeIdAnnotation.class);
        Mockito.when((Object)sourceType.getMetadataFormat()).thenReturn((Object)MetadataFormat.JAVA);
        Mockito.when((Object)targetType.getMetadataFormat()).thenReturn((Object)MetadataFormat.JAVA);
        Mockito.when((Object)sourceType.getAnnotation(TypeIdAnnotation.class)).thenReturn(Optional.of(sourceTypeIdAnnotation));
        Mockito.when((Object)targetType.getAnnotation(TypeIdAnnotation.class)).thenReturn(Optional.of(targetTypeIdAnnotation));
        Mockito.when((Object)sourceTypeIdAnnotation.getValue()).thenReturn((Object)String.class.getName());
        Mockito.when((Object)targetTypeIdAnnotation.getValue()).thenReturn((Object)Object.class.getName());
        Assert.assertTrue((String)"Object should be assignable from String", (boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
        Mockito.when((Object)sourceTypeIdAnnotation.getValue()).thenReturn((Object)Object.class.getName());
        Mockito.when((Object)targetTypeIdAnnotation.getValue()).thenReturn((Object)String.class.getName());
        Assert.assertFalse((String)"String should not be assignable from Object", (boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testObjectTypeWithTypeIdAnnotationClassNotFound() {
        ObjectType sourceType = (ObjectType)Mockito.mock(ObjectType.class);
        ObjectType targetType = (ObjectType)Mockito.mock(ObjectType.class);
        TypeIdAnnotation sourceTypeIdAnnotation = (TypeIdAnnotation)Mockito.mock(TypeIdAnnotation.class);
        TypeIdAnnotation targetTypeIdAnnotation = (TypeIdAnnotation)Mockito.mock(TypeIdAnnotation.class);
        Mockito.when((Object)sourceType.getMetadataFormat()).thenReturn((Object)MetadataFormat.JAVA);
        Mockito.when((Object)targetType.getMetadataFormat()).thenReturn((Object)MetadataFormat.JAVA);
        Mockito.when((Object)sourceType.getAnnotation(TypeIdAnnotation.class)).thenReturn(Optional.of(sourceTypeIdAnnotation));
        Mockito.when((Object)targetType.getAnnotation(TypeIdAnnotation.class)).thenReturn(Optional.of(targetTypeIdAnnotation));
        Mockito.when((Object)sourceTypeIdAnnotation.getValue()).thenReturn((Object)"NonExistentSourceClass");
        Mockito.when((Object)targetTypeIdAnnotation.getValue()).thenReturn((Object)"NonExistentTargetClass");
        Assert.assertFalse((boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testObjectTypeWithSourceTypeIdAnnotationMissing() {
        ObjectType sourceType = (ObjectType)Mockito.mock(ObjectType.class);
        ObjectType targetType = (ObjectType)Mockito.mock(ObjectType.class);
        TypeIdAnnotation targetTypeIdAnnotation = (TypeIdAnnotation)Mockito.mock(TypeIdAnnotation.class);
        Mockito.when((Object)sourceType.getMetadataFormat()).thenReturn((Object)MetadataFormat.JAVA);
        Mockito.when((Object)targetType.getMetadataFormat()).thenReturn((Object)MetadataFormat.JAVA);
        Mockito.when((Object)sourceType.getAnnotation(TypeIdAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)targetType.getAnnotation(TypeIdAnnotation.class)).thenReturn(Optional.of(targetTypeIdAnnotation));
        Assert.assertFalse((boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testObjectFieldTypeAssignability() {
        ObjectFieldType sourceField = (ObjectFieldType)Mockito.mock(ObjectFieldType.class);
        ObjectFieldType targetField = (ObjectFieldType)Mockito.mock(ObjectFieldType.class);
        ObjectKeyType sourceKey = (ObjectKeyType)Mockito.mock(ObjectKeyType.class);
        ObjectKeyType targetKey = (ObjectKeyType)Mockito.mock(ObjectKeyType.class);
        StringType sourceValue = (StringType)Mockito.mock(StringType.class);
        StringType targetValue = (StringType)Mockito.mock(StringType.class);
        Mockito.when((Object)sourceKey.getName()).thenReturn((Object)new QName("field"));
        Mockito.when((Object)targetKey.getName()).thenReturn((Object)new QName("field"));
        Mockito.when((Object)sourceKey.getAttributes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)targetKey.getAttributes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)sourceField.getKey()).thenReturn((Object)sourceKey);
        Mockito.when((Object)targetField.getKey()).thenReturn((Object)targetKey);
        Mockito.when((Object)sourceField.getValue()).thenReturn((Object)sourceValue);
        Mockito.when((Object)targetField.getValue()).thenReturn((Object)targetValue);
        Mockito.when((Object)sourceField.isRequired()).thenReturn((Object)true);
        Mockito.when((Object)targetField.isRequired()).thenReturn((Object)true);
        Assert.assertTrue((boolean)TypeAssignability.isAssignable((MetadataType)sourceField, (MetadataType)targetField, null));
        Mockito.when((Object)sourceField.isRequired()).thenReturn((Object)true);
        Mockito.when((Object)targetField.isRequired()).thenReturn((Object)false);
        Assert.assertTrue((boolean)TypeAssignability.isAssignable((MetadataType)sourceField, (MetadataType)targetField, null));
        Mockito.when((Object)sourceField.isRequired()).thenReturn((Object)false);
        Mockito.when((Object)targetField.isRequired()).thenReturn((Object)true);
        Assert.assertFalse((boolean)TypeAssignability.isAssignable((MetadataType)sourceField, (MetadataType)targetField, null));
    }

    @Test
    public void testObjectKeyTypeWithDifferentNames() {
        ObjectKeyType sourceKey = (ObjectKeyType)Mockito.mock(ObjectKeyType.class);
        ObjectKeyType targetKey = (ObjectKeyType)Mockito.mock(ObjectKeyType.class);
        Mockito.when((Object)sourceKey.getName()).thenReturn((Object)new QName("sourceField"));
        Mockito.when((Object)targetKey.getName()).thenReturn((Object)new QName("targetField"));
        Mockito.when((Object)sourceKey.getAttributes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)targetKey.getAttributes()).thenReturn(Collections.emptyList());
        Assert.assertFalse((boolean)TypeAssignability.isAssignable((MetadataType)sourceKey, (MetadataType)targetKey, null));
    }

    @Test
    public void testObjectKeyTypeWithSameNames() {
        ObjectKeyType sourceKey = (ObjectKeyType)Mockito.mock(ObjectKeyType.class);
        ObjectKeyType targetKey = (ObjectKeyType)Mockito.mock(ObjectKeyType.class);
        Mockito.when((Object)sourceKey.getName()).thenReturn((Object)new QName("sameField"));
        Mockito.when((Object)targetKey.getName()).thenReturn((Object)new QName("sameField"));
        Mockito.when((Object)sourceKey.getAttributes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)targetKey.getAttributes()).thenReturn(Collections.emptyList());
        Assert.assertTrue((boolean)TypeAssignability.isAssignable((MetadataType)sourceKey, (MetadataType)targetKey, null));
    }

    @Test
    public void testUnionTargetTypeWithIncompatibleTypes() {
        StringType sourceType = (StringType)Mockito.mock(StringType.class);
        UnionType targetType = (UnionType)Mockito.mock(UnionType.class);
        NumberType unionMember1 = (NumberType)Mockito.mock(NumberType.class);
        BooleanType unionMember2 = (BooleanType)Mockito.mock(BooleanType.class);
        Mockito.when((Object)targetType.getTypes()).thenReturn(Arrays.asList(unionMember1, unionMember2));
        Assert.assertFalse((boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }

    @Test
    public void testUnionSourceTypeWithNotAllTypesAssignable() {
        UnionType sourceType = (UnionType)Mockito.mock(UnionType.class);
        StringType targetType = (StringType)Mockito.mock(StringType.class);
        StringType unionMember1 = (StringType)Mockito.mock(StringType.class);
        NumberType unionMember2 = (NumberType)Mockito.mock(NumberType.class);
        Mockito.when((Object)sourceType.getTypes()).thenReturn(Arrays.asList(unionMember1, unionMember2));
        Assert.assertFalse((boolean)TypeAssignability.isAssignable((MetadataType)sourceType, (MetadataType)targetType, null));
    }
}

