/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

public class ComponentModelUtils {
    public static Optional<Stream<ComponentAst>> collectComponentModels(MessageProcessorNode messageProcessorNode, Predicate<? super ComponentAst> childComponentFilter) {
        if (messageProcessorNode == null) {
            return Optional.empty();
        }
        ComponentAst componentModel = messageProcessorNode.getComponentModel();
        if (componentModel == null) {
            return Optional.empty();
        }
        return Optional.of(componentModel.directChildrenStream().filter(childComponentFilter));
    }

    public static Optional<Stream<ComponentAst>> collectComponentModelsById(MessageProcessorNode messageProcessorNode, ComponentIdentifier componentIdentifier) {
        if (componentIdentifier == null) {
            return Optional.empty();
        }
        return ComponentModelUtils.collectComponentModels(messageProcessorNode, componentModel -> componentIdentifier.equals(componentModel.getIdentifier()));
    }

    public static Optional<ComponentAst> collectComponentModelById(MessageProcessorNode messageProcessorNode, ComponentIdentifier componentIdentifier) {
        return ComponentModelUtils.collectComponentModelsById(messageProcessorNode, componentIdentifier).flatMap(Stream::findFirst);
    }
}

