/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.builder;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MessageProcessorNodeBuilder;
import org.mule.metadata.api.model.FunctionType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

public class MessageProcessorNodeBuilderTest {
    private MessageProcessorNodeBuilder builder;
    private ComponentIdentifier componentIdentifier;

    @Before
    public void setUp() {
        this.componentIdentifier = ComponentIdentifier.builder().namespace("test").name("component").build();
        this.builder = new MessageProcessorNodeBuilder(this.componentIdentifier);
    }

    @Test
    public void testConstructorWithComponentIdentifier() {
        Assert.assertEquals((Object)this.componentIdentifier, (Object)this.builder.getComponentIdentifier());
        Assert.assertTrue((boolean)this.builder.getMessageProcessorNodeBuilderList().isEmpty());
    }

    @Test
    public void testConstructorWithString() {
        MessageProcessorNodeBuilder stringBuilder = new MessageProcessorNodeBuilder("test:component");
        Assert.assertEquals((Object)this.componentIdentifier, (Object)stringBuilder.getComponentIdentifier());
    }

    @Test
    public void testMessageProcessorWithBuilder() {
        MessageProcessorNodeBuilder childBuilder = new MessageProcessorNodeBuilder("child:component");
        this.builder.messageProcessor(childBuilder);
        Assert.assertEquals((long)1L, (long)this.builder.getMessageProcessorNodeBuilderList().size());
        Assert.assertEquals((Object)childBuilder, this.builder.getMessageProcessorNodeBuilderList().get(0));
    }

    @Test
    public void testMessageProcessorWithStringAndConsumer() {
        this.builder.messageProcessor("child:component", b -> b.synthetic());
        Assert.assertEquals((long)1L, (long)this.builder.getMessageProcessorNodeBuilderList().size());
        MessageProcessorNodeBuilder childBuilder = (MessageProcessorNodeBuilder)this.builder.getMessageProcessorNodeBuilderList().get(0);
        Assert.assertNotNull((Object)this.builder);
    }

    @Test
    public void testMessageProcessorWithComponentIdentifierAndConsumer() {
        ComponentIdentifier childIdentifier = ComponentIdentifier.builder().namespace("child").name("component").build();
        this.builder.messageProcessor(childIdentifier, b -> b.synthetic());
        Assert.assertEquals((long)1L, (long)this.builder.getMessageProcessorNodeBuilderList().size());
        MessageProcessorNodeBuilder childBuilder = (MessageProcessorNodeBuilder)this.builder.getMessageProcessorNodeBuilderList().get(0);
        Assert.assertEquals((Object)childIdentifier, (Object)childBuilder.getComponentIdentifier());
    }

    @Test
    public void testMessageProcessorWithString() {
        this.builder.messageProcessor("child:component");
        Assert.assertEquals((long)1L, (long)this.builder.getMessageProcessorNodeBuilderList().size());
        MessageProcessorNodeBuilder childBuilder = (MessageProcessorNodeBuilder)this.builder.getMessageProcessorNodeBuilderList().get(0);
        Assert.assertNotNull((Object)this.builder);
    }

    @Test
    public void testDeclaredFunctionType() {
        FunctionType mockFunctionType = (FunctionType)Mockito.mock(FunctionType.class);
        this.builder.declaredFunctionType(mockFunctionType);
        MessageProcessorNode node = this.builder.build();
        Assert.assertNotNull((Object)this.builder);
    }

    @Test
    public void testConfig() {
        ComponentAst mockComponentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.builder.config(mockComponentAst);
        MessageProcessorNode node = this.builder.build();
        Assert.assertEquals((Object)mockComponentAst, (Object)node.getComponentModel());
    }

    @Test
    public void testComponentModelType() {
        ComponentModelType mockComponentModelType = ComponentModelType.MESSAGE_PROCESSOR_NODE;
        this.builder.componentModelType(mockComponentModelType);
        MessageProcessorNode node = this.builder.build();
        Assert.assertEquals((Object)mockComponentModelType, node.getComponentModelType().get());
    }

    @Test
    public void testRoot() {
        this.builder.root();
        MessageProcessorNode node = this.builder.build();
        Assert.assertTrue((boolean)node.isRootMessageProcessorNode());
    }

    @Test
    public void testSynthetic() {
        this.builder.synthetic();
        MessageProcessorNode node = this.builder.build();
        Assert.assertTrue((boolean)node.isSynthetic());
    }

    @Test
    public void testBuild() {
        this.builder.messageProcessor("child1:component");
        this.builder.messageProcessor("child2:component");
        MessageProcessorNode node = this.builder.build();
        Assert.assertEquals((Object)this.componentIdentifier, (Object)node.getComponentIdentifier());
        Assert.assertNull((Object)node.getComponentModel());
    }
}

