/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.GlobalBindingsAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.phases.annotators.GlobalBindingsAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.GlobalBindingMetadataTypes;
import org.mule.metadata.api.model.MetadataType;

public class GlobalBindingsAnnotatorTest {
    private MuleApplicationNode muleApplicationNode;
    private AnnotatingMuleAstVisitorContext visitorContext;
    private DataSenseProviderResolver providerResolver;
    private GlobalBindingMetadataTypes globalBindingMetadataTypes;
    private MetadataType mockType;

    @Before
    public void setUp() {
        this.muleApplicationNode = (MuleApplicationNode)Mockito.mock(MuleApplicationNode.class);
        this.visitorContext = (AnnotatingMuleAstVisitorContext)Mockito.mock(AnnotatingMuleAstVisitorContext.class);
        this.providerResolver = (DataSenseProviderResolver)Mockito.mock(DataSenseProviderResolver.class);
        this.globalBindingMetadataTypes = (GlobalBindingMetadataTypes)Mockito.mock(GlobalBindingMetadataTypes.class);
        this.mockType = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)this.visitorContext.getDataSenseProviderResolver()).thenReturn((Object)this.providerResolver);
        Mockito.when((Object)this.providerResolver.getGlobalBindingMetadataTypes()).thenReturn((Object)this.globalBindingMetadataTypes);
        Mockito.when((Object)this.globalBindingMetadataTypes.muleType()).thenReturn((Object)this.mockType);
        Mockito.when((Object)this.globalBindingMetadataTypes.serverType()).thenReturn((Object)this.mockType);
        Mockito.when((Object)this.globalBindingMetadataTypes.appType()).thenReturn((Object)this.mockType);
        Mockito.when((Object)this.globalBindingMetadataTypes.flowType()).thenReturn((Object)this.mockType);
        Mockito.when((Object)this.globalBindingMetadataTypes.correlationIdType()).thenReturn((Object)this.mockType);
        Mockito.when((Object)this.globalBindingMetadataTypes.authenticationType()).thenReturn((Object)this.mockType);
        Mockito.when((Object)this.globalBindingMetadataTypes.dataTypeType()).thenReturn((Object)this.mockType);
        Mockito.when((Object)this.globalBindingMetadataTypes.itemSequenceInfoType()).thenReturn((Object)this.mockType);
        Mockito.when((Object)this.globalBindingMetadataTypes.errorType()).thenReturn((Object)this.mockType);
    }

    @Test
    public void testAnnotate() {
        GlobalBindingsAnnotator annotator = new GlobalBindingsAnnotator();
        annotator.annotate(this.muleApplicationNode, this.visitorContext);
        ((MuleApplicationNode)Mockito.verify((Object)this.muleApplicationNode)).annotate((AstNodeAnnotation)((GlobalBindingsAnnotation)Mockito.any(GlobalBindingsAnnotation.class)));
        ((GlobalBindingMetadataTypes)Mockito.verify((Object)this.globalBindingMetadataTypes)).muleType();
        ((GlobalBindingMetadataTypes)Mockito.verify((Object)this.globalBindingMetadataTypes)).serverType();
        ((GlobalBindingMetadataTypes)Mockito.verify((Object)this.globalBindingMetadataTypes)).appType();
        ((GlobalBindingMetadataTypes)Mockito.verify((Object)this.globalBindingMetadataTypes)).flowType();
        ((GlobalBindingMetadataTypes)Mockito.verify((Object)this.globalBindingMetadataTypes)).correlationIdType();
        ((GlobalBindingMetadataTypes)Mockito.verify((Object)this.globalBindingMetadataTypes)).authenticationType();
        ((GlobalBindingMetadataTypes)Mockito.verify((Object)this.globalBindingMetadataTypes)).dataTypeType();
        ((GlobalBindingMetadataTypes)Mockito.verify((Object)this.globalBindingMetadataTypes)).itemSequenceInfoType();
        ((GlobalBindingMetadataTypes)Mockito.verify((Object)this.globalBindingMetadataTypes)).errorType();
    }
}

