/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingUtils;
import org.mule.datasense.impl.util.LogSupport;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.util.LazyValue;

public class GlobalBindingMetadataTypes
implements LogSupport {
    public static final String GLOBAL_BINDING_MULE = "mule";
    public static final String GLOBAL_BINDING_SERVER = "server";
    public static final String GLOBAL_BINDING_APP = "app";
    public static final String GLOBAL_BINDING_FLOW = "flow";
    public static final String GLOBAL_BINDING_CORRELATION_ID = "correlationId";
    public static final String GLOBAL_BINDING_DATA_TYPE = "dataType";
    public static final String GLOBAL_BINDING_AUTHENTICATION = "authentication";
    public static final String GLOBAL_BINDING_ITEM_SEQUENCE_INFO = "itemSequenceInfo";
    public static final String GLOBAL_BINDING_ERROR = "error";
    private static final String GLOBAL_BINDING_DATA_TYPE_CLASS = "org.mule.runtime.api.metadata.DataType";
    private static final String GLOBAL_BINDING_AUTHENTICATION_CLASS = "org.mule.runtime.api.security.Authentication";
    private static final String GLOBAL_BINDING_ITEM_SEQUENCE_INFO_CLASS = "org.mule.runtime.api.message.ItemSequenceInfo";
    private static final String ERROR_CLASS = "org.mule.runtime.api.message.Error";
    private static final String TYPED_VALUE_CLASS = "org.mule.runtime.api.metadata.TypedValue";
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
    private final MetadataType correlationIdType;
    private final MetadataType dataTypeType;
    private final MetadataType authenticationType;
    private final MetadataType itemSequenceInfoType;
    private final MetadataType typedValueType;
    private final MetadataType appType;
    private final MetadataType serverType;
    private final MetadataType muleType;
    private final MetadataType errorType;
    private final MetadataType flowType;

    public static MetadataType getTypeFromJavaClass(String clazz) {
        return TypesHelper.getTypeFromJavaClass(clazz, GlobalBindingMetadataTypes.class.getClassLoader()).orElseThrow(() -> new IllegalArgumentException(String.format("Failed to resolve class type %s", clazz)));
    }

    private static Optional<MetadataType> getTypeFromWeave(String weaveTypeDef, String typeId, MetadataFormat metadataFormat, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        return expressionLanguageMetadataService.createTypeLoader(weaveTypeDef, Optional.ofNullable(metadataFormat).orElse(MetadataFormats.JAVA)).load(typeId);
    }

    private static Optional<MetadataType> getTypeFromWeave(String weaveTypeDef, String typeId, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        return GlobalBindingMetadataTypes.getTypeFromWeave(weaveTypeDef, typeId, null, expressionLanguageMetadataService);
    }

    private static MetadataType metadataTypeFromWeaveResource(String resource, String type, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        try {
            return GlobalBindingMetadataTypes.getTypeFromWeave(IOUtils.toString((InputStream)GlobalBindingMetadataTypes.class.getResourceAsStream(resource)), type, expressionLanguageMetadataService).orElseThrow(() -> new IllegalArgumentException(String.format("Failed to resolve weave type %s", type)));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public GlobalBindingMetadataTypes(ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.correlationIdType = CorrelationIdTypeHolder.singleton;
        this.dataTypeType = DataTypeTypeHolder.singleton;
        this.authenticationType = AuthenticationTypeHolder.singleton;
        this.itemSequenceInfoType = ItemSequenceInfoTypeHolder.singleton;
        this.typedValueType = TypedValueTypeHolder.singleton;
        this.appType = this.createAppType();
        this.serverType = this.createServerType();
        this.muleType = this.createMuleType();
        this.errorType = ErrorTypeTypeHolder.singleton;
        this.flowType = this.createFlowType();
    }

    public MetadataType correlationIdType() {
        return this.correlationIdType;
    }

    public MetadataType dataTypeType() {
        return this.dataTypeType;
    }

    public MetadataType authenticationType() {
        return this.authenticationType;
    }

    public MetadataType itemSequenceInfoType() {
        return this.itemSequenceInfoType;
    }

    public MetadataType typedValueType() {
        return this.typedValueType;
    }

    private MetadataType createAppType() {
        return AppTypeHolder.getValue(this.expressionLanguageMetadataService);
    }

    public MetadataType appType() {
        return this.appType;
    }

    private MetadataType createServerType() {
        return ServerTypeHolder.getValue(this.expressionLanguageMetadataService);
    }

    public MetadataType serverType() {
        return this.serverType;
    }

    private MetadataType createMuleType() {
        return MuleTypeHolder.getValue(this.expressionLanguageMetadataService);
    }

    public MetadataType muleType() {
        return this.muleType;
    }

    public MetadataType errorType() {
        return this.errorType;
    }

    private MetadataType createFlowType() {
        return FlowTypeHolder.getValue(this.expressionLanguageMetadataService);
    }

    public MetadataType flowType() {
        return this.flowType;
    }

    private static class CorrelationIdTypeHolder {
        private static final MetadataType singleton = TypesHelper.getTypeBuilder().stringType().build();

        private CorrelationIdTypeHolder() {
        }
    }

    private static class DataTypeTypeHolder {
        private static final MetadataType singleton = GlobalBindingMetadataTypes.getTypeFromJavaClass("org.mule.runtime.api.metadata.DataType");

        private DataTypeTypeHolder() {
        }
    }

    private static class AuthenticationTypeHolder {
        private static final MetadataType singleton = GlobalBindingMetadataTypes.getTypeFromJavaClass("org.mule.runtime.api.security.Authentication");

        private AuthenticationTypeHolder() {
        }
    }

    private static class ItemSequenceInfoTypeHolder {
        private static final MetadataType singleton = GlobalBindingMetadataTypes.getTypeFromJavaClass("org.mule.runtime.api.message.ItemSequenceInfo");

        private ItemSequenceInfoTypeHolder() {
        }
    }

    private static class TypedValueTypeHolder {
        private static final MetadataType singleton = GlobalBindingMetadataTypes.getTypeFromJavaClass("org.mule.runtime.api.metadata.TypedValue");

        private TypedValueTypeHolder() {
        }
    }

    private static class ErrorTypeTypeHolder {
        private static final MetadataType singleton = TypesHelper.getTypeFromJavaClass("org.mule.runtime.api.message.Error", GlobalBindingMetadataTypes.class.getClassLoader()).orElse(ErrorHandlingUtils.errorType(Collections.emptySet()));

        private ErrorTypeTypeHolder() {
        }
    }

    private static class AppTypeHolder {
        private static AtomicReference<LazyValue<MetadataType>> typeReference = new AtomicReference();

        private AppTypeHolder() {
        }

        public static MetadataType getValue(ExpressionLanguageMetadataService expressionLanguageMetadataService) {
            typeReference.compareAndSet(null, (LazyValue<MetadataType>)new LazyValue(() -> GlobalBindingMetadataTypes.metadataTypeFromWeaveResource("app-type.dw", "DataWeaveArtifactContext", expressionLanguageMetadataService)));
            return (MetadataType)typeReference.get().get();
        }
    }

    private static class ServerTypeHolder {
        private static AtomicReference<LazyValue<MetadataType>> typeReference = new AtomicReference();

        private ServerTypeHolder() {
        }

        public static MetadataType getValue(ExpressionLanguageMetadataService expressionLanguageMetadataService) {
            typeReference.compareAndSet(null, (LazyValue<MetadataType>)new LazyValue(() -> GlobalBindingMetadataTypes.metadataTypeFromWeaveResource("server-type.dw", "ServerContext", expressionLanguageMetadataService)));
            return (MetadataType)typeReference.get().get();
        }
    }

    private static class MuleTypeHolder {
        private static AtomicReference<LazyValue<MetadataType>> typeReference = new AtomicReference();

        private MuleTypeHolder() {
        }

        public static MetadataType getValue(ExpressionLanguageMetadataService expressionLanguageMetadataService) {
            typeReference.compareAndSet(null, (LazyValue<MetadataType>)new LazyValue(() -> GlobalBindingMetadataTypes.metadataTypeFromWeaveResource("mule-type.dw", "MuleInstanceContext", expressionLanguageMetadataService)));
            return (MetadataType)typeReference.get().get();
        }
    }

    private static class FlowTypeHolder {
        private static AtomicReference<LazyValue<MetadataType>> typeReference = new AtomicReference();

        private FlowTypeHolder() {
        }

        public static MetadataType getValue(ExpressionLanguageMetadataService expressionLanguageMetadataService) {
            typeReference.compareAndSet(null, (LazyValue<MetadataType>)new LazyValue(() -> GlobalBindingMetadataTypes.metadataTypeFromWeaveResource("flow-type.dw", "NamedObject", expressionLanguageMetadataService)));
            return (MetadataType)typeReference.get().get();
        }
    }
}

