/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallBuilderAnnotation;
import org.mule.datasense.impl.model.annotations.metadata.SourceModelAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.phases.annotators.StaticSourceAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.datasense.impl.util.TreeLogSupport;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.ComponentAst;

public class StaticSourceAnnotatorTest {
    private DataSenseProviderResolver dataSenseProviderResolver;
    private MessageProcessorNode messageProcessorNode;
    private AnnotatingMuleAstVisitorContext visitorContext;
    private ComponentAst componentAst;
    private SourceModel sourceModel;
    private MuleFlowAnnotation muleFlowAnnotation;
    private TreeLogSupport logger;
    private OperationCallBuilder operationCallBuilder;
    private OutputModel outputModel;
    private OutputModel outputAttributesModel;
    private MetadataType metadataType;

    @Before
    public void setUp() {
        this.dataSenseProviderResolver = (DataSenseProviderResolver)Mockito.mock(DataSenseProviderResolver.class);
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.visitorContext = (AnnotatingMuleAstVisitorContext)Mockito.mock(AnnotatingMuleAstVisitorContext.class);
        this.componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.sourceModel = (SourceModel)Mockito.mock(SourceModel.class);
        this.muleFlowAnnotation = (MuleFlowAnnotation)Mockito.mock(MuleFlowAnnotation.class);
        this.logger = (TreeLogSupport)Mockito.mock(TreeLogSupport.class);
        this.operationCallBuilder = (OperationCallBuilder)Mockito.mock(OperationCallBuilder.class);
        this.outputModel = (OutputModel)Mockito.mock(OutputModel.class);
        this.outputAttributesModel = (OutputModel)Mockito.mock(OutputModel.class);
        this.metadataType = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)this.sourceModel.getOutput()).thenReturn((Object)this.outputModel);
        Mockito.when((Object)this.sourceModel.getOutputAttributes()).thenReturn((Object)this.outputAttributesModel);
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)this.metadataType);
        Mockito.when((Object)this.outputAttributesModel.getType()).thenReturn((Object)this.metadataType);
        Mockito.when((Object)this.outputModel.hasDynamicType()).thenReturn((Object)false);
        Mockito.when((Object)this.outputAttributesModel.hasDynamicType()).thenReturn((Object)false);
        Mockito.when((Object)this.visitorContext.logger()).thenReturn((Object)this.logger);
        ((TreeLogSupport)Mockito.doNothing().when((Object)this.logger)).debug(Mockito.anyString(), (Object[])Mockito.any(Object[].class));
        ((TreeLogSupport)Mockito.doNothing().when((Object)this.logger)).debug(Mockito.anyString(), new Object[0]);
        OperationCallBuilderAnnotation operationCallBuilderAnnotation = (OperationCallBuilderAnnotation)Mockito.mock(OperationCallBuilderAnnotation.class);
        Mockito.when((Object)operationCallBuilderAnnotation.getOperationCallBuilder()).thenReturn((Object)this.operationCallBuilder);
        Mockito.when((Object)((OperationCallBuilderAnnotation)this.messageProcessorNode.getOrCreateAnnotation((Class)Mockito.eq(OperationCallBuilderAnnotation.class), (Supplier)Mockito.any()))).thenReturn((Object)operationCallBuilderAnnotation);
        Mockito.when((Object)this.operationCallBuilder.name(Mockito.anyString())).thenReturn((Object)this.operationCallBuilder);
        Mockito.when((Object)this.operationCallBuilder.input(Mockito.anyString(), (Consumer)Mockito.any())).thenReturn((Object)this.operationCallBuilder);
        Mockito.when((Object)this.operationCallBuilder.returnType((MetadataType)Mockito.any())).thenReturn((Object)this.operationCallBuilder);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentAst);
        Mockito.when((Object)this.visitorContext.getDataSenseProviderResolver()).thenReturn((Object)this.dataSenseProviderResolver);
        Mockito.when((Object)this.visitorContext.getAnnotation(MuleFlowAnnotation.class)).thenReturn(Optional.of(this.muleFlowAnnotation));
        Mockito.when((Object)this.sourceModel.getName()).thenReturn((Object)"testSource");
        Mockito.when((Object)this.sourceModel.getAllParameterModels()).thenReturn(Collections.emptyList());
    }

    @Test
    public void testAnnotateWithSourceModel() {
        Mockito.when((Object)this.dataSenseProviderResolver.resolveSourceModel(this.componentAst)).thenReturn(Optional.of(this.sourceModel));
        StaticSourceAnnotator annotator = new StaticSourceAnnotator();
        annotator.annotate(this.messageProcessorNode, this.visitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((SourceModelAnnotation)Mockito.any(SourceModelAnnotation.class)));
    }

    @Test
    public void testAnnotateWithNoSourceModel() {
        Mockito.when((Object)this.dataSenseProviderResolver.resolveSourceModel(this.componentAst)).thenReturn(Optional.empty());
        StaticSourceAnnotator annotator = new StaticSourceAnnotator();
        annotator.annotate(this.messageProcessorNode, this.visitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).annotate((AstNodeAnnotation)((SourceModelAnnotation)Mockito.any(SourceModelAnnotation.class)));
    }
}

