/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.api.metadataprovider.DataSenseConfiguration;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.impl.model.annotations.ComponentModelMetadataKeyEnricher;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.operation.InputMapping;
import org.mule.datasense.impl.model.operation.InputParameter;
import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;

@RunWith(value=MockitoJUnitRunner.class)
public class ComponentModelMetadataKeyEnricherTest {
    @Mock
    private ComponentAst componentAst;
    @Mock
    private OperationCall operationCall;
    @Mock
    private Location location;
    @Mock
    private DataSenseMetadataProvider dataSenseMetadataProvider;
    @Mock
    private AstNotification astNotification;
    private ComponentModelMetadataKeyEnricher<Object> enricher;

    @Before
    public void setup() {
        this.enricher = new ComponentModelMetadataKeyEnricher<Object>(){

            protected Object enrich(Object componentModel, Map<String, Set<MetadataKey>> metadataKeysByPart, OperationCall operationCall) {
                return componentModel;
            }
        };
    }

    @Test
    public void testGetPartName() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        HashSet<MetadataKey> metadataKeys = new HashSet<MetadataKey>();
        MetadataKey key = (MetadataKey)Mockito.mock(MetadataKey.class);
        Mockito.when((Object)key.getPartName()).thenReturn((Object)"testPart");
        metadataKeys.add(key);
        Method method = ComponentModelMetadataKeyEnricher.class.getDeclaredMethod("getPartName", Set.class);
        method.setAccessible(true);
        String result = (String)method.invoke(this.enricher, metadataKeys);
        Assert.assertEquals((Object)"testPart", (Object)result);
    }

    @Test
    public void testEnrichAnnotations() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        HashSet<MetadataKey> metadataKeys = new HashSet<MetadataKey>();
        MetadataKey key = (MetadataKey)Mockito.mock(MetadataKey.class);
        metadataKeys.add(key);
        Method method = ComponentModelMetadataKeyEnricher.class.getDeclaredMethod("enrichAnnotations", Set.class, StringTypeBuilder.class, Set.class);
        method.setAccessible(true);
        String result = (String)method.invoke(this.enricher, new HashSet(), Mockito.mock(StringTypeBuilder.class), new HashSet());
        Assert.assertNull((Object)result);
    }

    @Test
    public void testEnumOfKeyValues() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        HashSet<MetadataKey> metadataKeys = new HashSet<MetadataKey>();
        MetadataKey key1 = (MetadataKey)Mockito.mock(MetadataKey.class);
        MetadataKey key2 = (MetadataKey)Mockito.mock(MetadataKey.class);
        Mockito.when((Object)key1.getId()).thenReturn((Object)"id1");
        Mockito.when((Object)key2.getId()).thenReturn((Object)"id2");
        metadataKeys.add(key1);
        metadataKeys.add(key2);
        Method method = ComponentModelMetadataKeyEnricher.class.getDeclaredMethod("enumOfKeyValues", Set.class);
        method.setAccessible(true);
        String[] result = (String[])method.invoke(this.enricher, metadataKeys);
        Assert.assertNotEquals((Object)new String[]{"id1", "id2"}, (Object)result);
    }

    @Test
    public void testFindKeyPartConfiguredValue() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ComponentParameterAst parameter = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"testParam");
        Mockito.when((Object)parameter.getModel()).thenReturn((Object)parameterModel);
        Mockito.when((Object)parameter.isDefaultValue()).thenReturn((Object)false);
        Mockito.when((Object)parameter.getValue()).thenReturn((Object)Either.right((Object)"testValue"));
        List<ComponentParameterAst> parameters = Collections.singletonList(parameter);
        Mockito.when((Object)this.componentAst.getParameters()).thenReturn(parameters);
        Method method = ComponentModelMetadataKeyEnricher.class.getDeclaredMethod("findKeyPartConfiguredValue", ComponentAst.class, String.class);
        method.setAccessible(true);
        Optional result = (Optional)method.invoke(this.enricher, this.componentAst, "testParam");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"testValue", result.get());
    }

    @Test
    public void testFilterMetadataKeys() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        HashMap metadataKeysByPart = new HashMap();
        HashSet<MetadataKey> metadataKeys = new HashSet<MetadataKey>();
        MetadataKey key = (MetadataKey)Mockito.mock(MetadataKey.class);
        ComponentParameterAst componentParameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)key.getPartName()).thenReturn((Object)"testPart");
        metadataKeys.add(key);
        Mockito.when((Object)key.getId()).thenReturn((Object)"true");
        Mockito.when((Object)this.componentAst.getParameters()).thenReturn(Arrays.asList(componentParameterAst));
        Mockito.when((Object)componentParameterAst.getModel()).thenReturn((Object)((ParameterModel)Mockito.mock(ParameterModel.class)));
        Mockito.when((Object)componentParameterAst.getModel().getName()).thenReturn((Object)"testPart");
        Mockito.when((Object)componentParameterAst.getValue()).thenReturn((Object)Either.right((Object)"true"));
        Method method = ComponentModelMetadataKeyEnricher.class.getDeclaredMethod("filterMetadataKeys", Map.class, Set.class, ComponentAst.class);
        method.setAccessible(true);
        method.invoke(this.enricher, metadataKeysByPart, metadataKeys, this.componentAst);
        Assert.assertTrue((boolean)metadataKeysByPart.containsKey("testPart"));
        Assert.assertEquals(metadataKeys, metadataKeysByPart.get("testPart"));
    }

    @Test
    public void testGetParameterModelMetadataTypeFunctionStringType() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        HashMap<String, Set<MetadataKey>> metadataKeysByPart = new HashMap<String, Set<MetadataKey>>();
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        InputMapping inputMapping = (InputMapping)Mockito.mock(InputMapping.class);
        MetadataKey metadataKey = (MetadataKey)Mockito.mock(MetadataKey.class);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"testParam");
        Mockito.when((Object)parameterModel.getType()).thenReturn((Object)((MetadataType)Mockito.mock(StringType.class)));
        Mockito.when((Object)this.operationCall.getInputMappings()).thenReturn(Stream.of(inputMapping));
        Mockito.when((Object)inputMapping.getInputParameter()).thenReturn((Object)((InputParameter)Mockito.mock(InputParameter.class)));
        Mockito.when((Object)inputMapping.getInputParameter().getMetadataType()).thenReturn((Object)((MetadataType)Mockito.mock(MetadataType.class)));
        Mockito.when((Object)inputMapping.getInputParameter().getName()).thenReturn((Object)"name");
        metadataKeysByPart.put(parameterModel.getName(), Collections.singleton(metadataKey));
        Method method = ComponentModelMetadataKeyEnricher.class.getDeclaredMethod("getParameterModelMetadataTypeFunction", Map.class, OperationCall.class);
        method.setAccessible(true);
        Function function = (Function)method.invoke(this.enricher, metadataKeysByPart, this.operationCall);
        MetadataType result = (MetadataType)function.apply(parameterModel);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof StringType));
    }

    @Test
    public void testEnrichMetadataResultSuccess() {
        ComponentModel componentModel = (ComponentModel)Mockito.mock(ComponentModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        MetadataResult metadataResult = (MetadataResult)Mockito.mock(MetadataResult.class);
        HashMap<String, HashSet<MetadataKey>> map = new HashMap<String, HashSet<MetadataKey>>();
        map.put("temp", new HashSet<MetadataKey>(Arrays.asList((MetadataKey)Mockito.mock(MetadataKey.class))));
        MetadataKeysContainer metadataKeysContainer = (MetadataKeysContainer)Mockito.mock(MetadataKeysContainer.class);
        Optional<DataSenseConfiguration> dataSenseConfigurationOptional = Optional.of((DataSenseConfiguration)Mockito.mock(DataSenseConfiguration.class));
        Mockito.when((Object)dataSenseConfigurationOptional.get().isKeyEnrichment()).thenReturn((Object)true);
        Mockito.when((Object)this.dataSenseMetadataProvider.getMetadataKeys((ComponentAst)ArgumentMatchers.any())).thenReturn((Object)metadataResult);
        Mockito.when((Object)metadataResult.isSuccess()).thenReturn((Object)true);
        Mockito.when((Object)metadataResult.get()).thenReturn((Object)metadataKeysContainer);
        Mockito.when((Object)metadataKeysContainer.getKeysByCategory()).thenReturn(map);
        Mockito.when((Object)this.componentAst.getModel(ComponentModel.class)).thenReturn(Optional.of(componentModel));
        Mockito.when((Object)componentModel.getAllParameterModels()).thenReturn(Arrays.asList(parameterModel));
        Mockito.when((Object)parameterModel.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.of(new MetadataKeyPartModelProperty(1)));
        Object result = this.enricher.enrich((Object)componentModel, this.componentAst, this.operationCall, this.location, this.dataSenseMetadataProvider, this.astNotification, dataSenseConfigurationOptional);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)componentModel, (Object)result);
    }

    @Test
    public void testEnrichMetadataResultFalse() {
        ComponentModel componentModel = (ComponentModel)Mockito.mock(ComponentModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        MetadataResult metadataResult = (MetadataResult)Mockito.mock(MetadataResult.class);
        MetadataFailure metadataFailure = MetadataFailure.Builder.newFailure((Exception)new RuntimeException("Test Exception")).onComponent();
        HashMap<String, HashSet<MetadataKey>> map = new HashMap<String, HashSet<MetadataKey>>();
        map.put("temp", new HashSet<MetadataKey>(Arrays.asList((MetadataKey)Mockito.mock(MetadataKey.class))));
        Optional<DataSenseConfiguration> dataSenseConfigurationOptional = Optional.of((DataSenseConfiguration)Mockito.mock(DataSenseConfiguration.class));
        Mockito.when((Object)dataSenseConfigurationOptional.get().isKeyEnrichment()).thenReturn((Object)true);
        Mockito.when((Object)this.dataSenseMetadataProvider.getMetadataKeys((ComponentAst)ArgumentMatchers.any())).thenReturn((Object)metadataResult);
        Mockito.when((Object)metadataResult.isSuccess()).thenReturn((Object)false);
        Mockito.when((Object)metadataResult.getFailures()).thenReturn(Arrays.asList(metadataFailure));
        Mockito.when((Object)this.componentAst.getLocation()).thenReturn((Object)((ComponentLocation)Mockito.mock(ComponentLocation.class)));
        Mockito.when((Object)this.componentAst.getModel(ComponentModel.class)).thenReturn(Optional.of(componentModel));
        Mockito.when((Object)componentModel.getAllParameterModels()).thenReturn(Arrays.asList(parameterModel));
        Mockito.when((Object)parameterModel.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.of(new MetadataKeyPartModelProperty(1)));
        Object result = this.enricher.enrich((Object)componentModel, this.componentAst, this.operationCall, this.location, this.dataSenseMetadataProvider, this.astNotification, dataSenseConfigurationOptional);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)componentModel, (Object)result);
    }
}

