/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.batch;

import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitor;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitorContext;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.ScopeTypeResolver;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.runtime.api.component.ComponentIdentifier;

public class BatchAggregatorTypeResolver
extends ScopeTypeResolver {
    private static final String ATTR_STREAMING = "streaming";
    private static final String VARIABLE_RECORD = "record";
    private static final String VARIABLE_RECORDS = "records";

    public BatchAggregatorTypeResolver(ComponentIdentifier componentIdentiferScopeIn, ComponentIdentifier componentIdentiferScopeOut) {
        super(componentIdentiferScopeIn, componentIdentiferScopeOut);
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }

    public static class ScopeIn
    extends ScopeTypeResolver.ScopeIn {
        @Override
        protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
            EventType scopeEventType = this.buildInnerEventType(messageProcessorNode, inputEventType, visitorContext);
            messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
            messageProcessorNode.annotate(new DefinesTypeAnnotation(scopeEventType));
            return inputEventType;
        }

        private EventType buildInnerEventType(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitorContext visitorContext) {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().payload().arrayType().of((MetadataType)TypeUtils.getMessageMetadataType(inputEventType).flatMap(MessageMetadataType::getPayloadType).orElse(TypesHelper.getTypeBuilder().anyType().build()));
            muleEventMetadataTypeBuilder.message().attributes().voidType();
            MuleEventMetadataTypeBuilder recordType = TypeUtils.asMuleEventMetadataType(inputEventType);
            if (this.isStreaming(messageProcessorNode)) {
                muleEventMetadataTypeBuilder.addVariable(BatchAggregatorTypeResolver.VARIABLE_RECORD, (MetadataType)recordType.build());
            } else {
                muleEventMetadataTypeBuilder.addVariable(BatchAggregatorTypeResolver.VARIABLE_RECORDS, (MetadataType)TypesHelper.getTypeBuilder().arrayType().of((TypeBuilder)recordType).build());
            }
            MuleEventMetadataType muleEventMetadataType = muleEventMetadataTypeBuilder.build();
            return TypeUtils.asEventType(muleEventMetadataType);
        }

        private boolean isStreaming(MessageProcessorNode messageProcessorNode) {
            return (Boolean)messageProcessorNode.getComponentModel().getParameter("General", BatchAggregatorTypeResolver.ATTR_STREAMING).getValue().getRight();
        }

        @Override
        public EventType generateExpected(MessageProcessorNode messageProcessorNode, ExpectedAstVisitor expectedAstVisitor, ExpectedAstVisitorContext visitorContext) {
            return visitorContext.getExpectedEventType();
        }
    }
}

