/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.impl.DataSenseApplicationModel;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.phases.annotators.AnnotatorsRegistry;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.datasense.testutil.ReflectionTestUtils;
import org.mule.datasenseapi.api.ApplicationResolutionScope;
import org.mule.datasenseapi.api.DataSenseResolutionScope;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class DataSenseApplicationModelTest {
    @Mock
    private ApplicationResolutionScope mockDataSenseResolutionScope;
    @Mock
    private ApplicationModel mockApplicationModel;
    @Mock
    private DataSenseProvider mockDataSenseProvider;
    @Mock
    private TypeResolverRegistry mockTypeResolverRegistry;
    @Mock
    private AstNotification mockAstNotification;
    @Mock
    private ArtifactAst mockArtifactAst;
    @Mock
    private MuleApplicationNode mockMuleApplicationNode;
    @Mock
    private DataSenseProviderResolver mockDataSenseProviderResolver;
    private DataSenseApplicationModel dataSenseApplicationModel;

    @Before
    public void setUp() {
        this.dataSenseApplicationModel = new DataSenseApplicationModel((DataSenseResolutionScope)this.mockDataSenseResolutionScope, this.mockApplicationModel, this.mockDataSenseProvider, this.mockTypeResolverRegistry, this.mockAstNotification);
        ReflectionTestUtils.setField(this.dataSenseApplicationModel, "muleApplicationNode", this.mockMuleApplicationNode);
        ReflectionTestUtils.setField(this.dataSenseApplicationModel, "dataSenseProviderResolver", this.mockDataSenseProviderResolver);
    }

    @Test
    public void parse_ThrowsException() {
        try {
            Method method = DataSenseApplicationModel.class.getDeclaredMethod("parse", ArtifactAst.class);
            method.setAccessible(true);
            ArtifactAst artifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
            method.invoke((Object)this.dataSenseApplicationModel, artifactAst);
            Assert.assertTrue((boolean)true);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void parse() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException {
        Method method = DataSenseApplicationModel.class.getDeclaredMethod("parse", ArtifactAst.class);
        method.setAccessible(true);
        ArtifactAst artifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        Field field = DataSenseApplicationModel.class.getDeclaredField("dataSenseProviderResolver");
        field.setAccessible(true);
        field.set(this.dataSenseApplicationModel, Mockito.mock(DataSenseProviderResolver.class));
        method.invoke((Object)this.dataSenseApplicationModel, artifactAst);
        Assert.assertNotNull((Object)this.dataSenseApplicationModel);
    }

    @Test
    public void testGetMuleApplicationNode() {
        MuleApplicationNode mockMuleApplicationNode = (MuleApplicationNode)Mockito.mock(MuleApplicationNode.class);
        ReflectionTestUtils.setField(this.dataSenseApplicationModel, "muleApplicationNode", mockMuleApplicationNode);
        MuleApplicationNode result = this.dataSenseApplicationModel.getMuleApplicationNode();
        Assert.assertEquals((Object)mockMuleApplicationNode, (Object)result);
    }

    @Test
    public void testGetDataSenseProviderResolver() {
        DataSenseProviderResolver mockDataSenseProviderResolver = (DataSenseProviderResolver)Mockito.mock(DataSenseProviderResolver.class);
        ReflectionTestUtils.setField(this.dataSenseApplicationModel, "dataSenseProviderResolver", mockDataSenseProviderResolver);
        DataSenseProviderResolver result = this.dataSenseApplicationModel.getDataSenseProviderResolver();
        Assert.assertEquals((Object)mockDataSenseProviderResolver, (Object)result);
    }

    @Test
    public void testBuild() {
    }

    @Test
    public void testResolve() {
        try {
            this.dataSenseApplicationModel.resolve();
            Assert.assertTrue((boolean)true);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testCreateInitialEvent() throws Exception {
        Method method = DataSenseApplicationModel.class.getDeclaredMethod("createInitialEvent", new Class[0]);
        method.setAccessible(true);
        Object result = method.invoke((Object)this.dataSenseApplicationModel, new Object[0]);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testFindMessageProcessorNode() {
        Location location = (Location)Mockito.mock(Location.class);
        MessageProcessorNode messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)this.mockMuleApplicationNode.findMessageProcessorNode(location)).thenReturn(Optional.of(messageProcessorNode));
        Optional result = this.dataSenseApplicationModel.findMessageProcessorNode(location);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)messageProcessorNode, result.get());
    }

    @Test
    public void testFindMessageProcessorNodeEmpty() {
        Location location = (Location)Mockito.mock(Location.class);
        Mockito.when((Object)this.mockMuleApplicationNode.findMessageProcessorNode(location)).thenReturn(Optional.empty());
        Optional result = this.dataSenseApplicationModel.findMessageProcessorNode(location);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testFind() {
        Location location = (Location)Mockito.mock(Location.class);
        MessageProcessorNode messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        ComponentAst componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)this.mockMuleApplicationNode.findMessageProcessorNode(location)).thenReturn(Optional.of(messageProcessorNode));
        Mockito.when((Object)messageProcessorNode.getComponentModel()).thenReturn((Object)componentAst);
        Optional result = this.dataSenseApplicationModel.find(location);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)componentAst, result.get());
    }

    @Test
    public void testFindEmpty() {
        Location location = (Location)Mockito.mock(Location.class);
        Mockito.when((Object)this.mockMuleApplicationNode.findMessageProcessorNode(location)).thenReturn(Optional.empty());
        Optional result = this.dataSenseApplicationModel.find(location);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testResolveComponentTrue() {
        Location location = (Location)Mockito.mock(Location.class);
        MessageProcessorNode messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        MuleFlowNode muleFlowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        String flowName = "testFlow";
        Mockito.when((Object)location.getGlobalName()).thenReturn((Object)flowName);
        Mockito.when((Object)this.mockMuleApplicationNode.findMessageProcessorNode(location)).thenReturn(Optional.of(messageProcessorNode));
        Mockito.when((Object)this.mockMuleApplicationNode.findMuleFlowNode(flowName)).thenReturn(Optional.of(muleFlowNode));
        boolean result = this.dataSenseApplicationModel.resolveComponent(location);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testResolveComponentFalse() {
        Location location = (Location)Mockito.mock(Location.class);
        Mockito.when((Object)this.mockMuleApplicationNode.findMessageProcessorNode(location)).thenReturn(Optional.empty());
        boolean result = this.dataSenseApplicationModel.resolveComponent(location);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testCreateAnnotatorsRegistry() throws Exception {
        Method method = DataSenseApplicationModel.class.getDeclaredMethod("createAnnotatorsRegistry", new Class[0]);
        method.setAccessible(true);
        AnnotatorsRegistry result = (AnnotatorsRegistry)method.invoke((Object)this.dataSenseApplicationModel, new Object[0]);
        Assert.assertNotNull((Object)result);
    }
}

