/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.datasense.declarations.model.ExtensionOperationTypeDeclaration;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.OperationCallBuilderAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.phases.annotators.OperationCallCustomizerAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.metadata.api.model.FunctionParameter;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.ast.api.ComponentAst;

public class OperationCallCustomizerAnnotatorTest {
    private OperationCallCustomizerAnnotator annotator;
    private MessageProcessorNode messageProcessorNode;
    private AnnotatingMuleAstVisitorContext context;
    private OperationCallBuilder operationCallBuilder;
    private OperationCallBuilderAnnotation operationCallBuilderAnnotation;

    @Before
    public void setUp() {
        this.annotator = new OperationCallCustomizerAnnotator();
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.context = (AnnotatingMuleAstVisitorContext)Mockito.mock(AnnotatingMuleAstVisitorContext.class);
        this.operationCallBuilder = (OperationCallBuilder)Mockito.mock(OperationCallBuilder.class);
        this.operationCallBuilderAnnotation = (OperationCallBuilderAnnotation)Mockito.mock(OperationCallBuilderAnnotation.class);
    }

    @Test
    public void testAnnotateWithNoOperationCallBuilderAnnotation() {
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(OperationCallBuilderAnnotation.class)).thenReturn(Optional.empty());
        this.annotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).annotate((AstNodeAnnotation)Mockito.any());
    }

    @Test
    public void testAnnotateWithNoExtensionOperationTypeDeclaration() {
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(OperationCallBuilderAnnotation.class)).thenReturn(Optional.of(this.operationCallBuilderAnnotation));
        Mockito.when((Object)this.operationCallBuilderAnnotation.getOperationCallBuilder()).thenReturn((Object)this.operationCallBuilder);
        ComponentAst componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        ExtensionOperationTypeDeclaration dec = (ExtensionOperationTypeDeclaration)Mockito.mock(ExtensionOperationTypeDeclaration.class);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)componentAst);
        Mockito.when((Object)this.context.getDataSenseProviderResolver()).thenReturn((Object)((DataSenseProviderResolver)Mockito.mock(DataSenseProviderResolver.class)));
        Mockito.when((Object)this.context.getDataSenseProviderResolver().findExtensionOperationTypeDeclaration(componentAst)).thenReturn(Optional.of(dec));
        Mockito.when((Object)dec.getFunctionType()).thenReturn((Object)((FunctionType)Mockito.mock(FunctionType.class)));
        Mockito.when((Object)dec.getFunctionType().getParameters()).thenReturn(Arrays.asList((FunctionParameter)Mockito.mock(FunctionParameter.class)));
        Mockito.when((Object)dec.getFunctionType().getReturnType()).thenReturn(Optional.of((MetadataType)Mockito.mock(MetadataType.class)));
        this.annotator.annotate(this.messageProcessorNode, this.context);
        ((OperationCallBuilder)Mockito.verify((Object)this.operationCallBuilder, (VerificationMode)Mockito.never())).input(Mockito.anyString(), (Consumer)Mockito.any());
    }
}

