/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.munit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.phases.typing.resolver.munit.MUnitSetEventParser;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

public class MUnitSetEventParserTest {
    private MUnitSetEventParser parser;
    private ComponentAst setEventComponentModel;
    private MuleEventExprBuilder muleEventExprBuilder;

    @Before
    public void setUp() {
        this.parser = new MUnitSetEventParser();
        this.setEventComponentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.muleEventExprBuilder = (MuleEventExprBuilder)Mockito.mock(MuleEventExprBuilder.class);
        Mockito.when((Object)this.setEventComponentModel.getParameter(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)((ComponentParameterAst)Mockito.mock(ComponentParameterAst.class)));
        Mockito.when((Object)this.setEventComponentModel.getParameter(Mockito.anyString(), Mockito.anyString()).getValue()).thenReturn((Object)Either.left((Object)"abc"));
    }

    @Test
    public void testParsePayload() {
        ComponentAst payloadModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentParameterAst valueParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        ComponentParameterAst mediaTypeParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)this.setEventComponentModel.getParameter("", "payload")).thenReturn((Object)((ComponentParameterAst)Mockito.mock(ComponentParameterAst.class)));
        Mockito.when((Object)this.setEventComponentModel.getParameter("", "payload").getValue()).thenReturn((Object)Either.right((Object)payloadModel));
        Mockito.when((Object)payloadModel.getParameter("Payload", "value")).thenReturn((Object)valueParam);
        Mockito.when((Object)payloadModel.getParameter("Payload", "mediaType")).thenReturn((Object)mediaTypeParam);
        Mockito.when((Object)valueParam.getValue()).thenReturn((Object)Either.right((Object)"test payload"));
        Mockito.when((Object)mediaTypeParam.getValue()).thenReturn((Object)Either.right((Object)"application/json"));
        this.parser.parse(this.setEventComponentModel, this.muleEventExprBuilder);
        Assert.assertNotNull((Object)this.setEventComponentModel);
    }

    @Test
    public void testParseAttributes() {
        ComponentAst attributesModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentParameterAst valueParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        ComponentParameterAst mediaTypeParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)this.setEventComponentModel.getParameter("", "attributes")).thenReturn((Object)((ComponentParameterAst)Mockito.mock(ComponentParameterAst.class)));
        Mockito.when((Object)this.setEventComponentModel.getParameter("", "attributes").getValue()).thenReturn((Object)Either.right((Object)attributesModel));
        Mockito.when((Object)attributesModel.getParameter("EventAttributes", "value")).thenReturn((Object)valueParam);
        Mockito.when((Object)attributesModel.getParameter("EventAttributes", "mediaType")).thenReturn((Object)mediaTypeParam);
        Mockito.when((Object)valueParam.getValue()).thenReturn((Object)Either.right((Object)"test attributes"));
        Mockito.when((Object)mediaTypeParam.getValue()).thenReturn((Object)Either.right((Object)"application/json"));
        this.parser.parse(this.setEventComponentModel, this.muleEventExprBuilder);
        Assert.assertNotNull((Object)this.setEventComponentModel);
    }

    @Test
    public void testParseWithVariables() {
        ComponentAst variableModel1 = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentAst variableModel2 = (ComponentAst)Mockito.mock(ComponentAst.class);
        List<ComponentAst> variableModels = Arrays.asList(variableModel1, variableModel2);
        Mockito.when((Object)this.setEventComponentModel.getParameter("", "variables")).thenReturn((Object)((ComponentParameterAst)Mockito.mock(ComponentParameterAst.class)));
        Mockito.when((Object)this.setEventComponentModel.getParameter("", "variables").getValue()).thenReturn((Object)Either.right(variableModels));
        this.mockVariableModel(variableModel1, "var1", "value1", "text/plain");
        this.mockVariableModel(variableModel2, "var2", "value2", "application/json");
        this.parser.parse(this.setEventComponentModel, this.muleEventExprBuilder);
        Assert.assertNotNull((Object)this.setEventComponentModel);
    }

    private void mockVariableModel(ComponentAst variableModel, String key, String value, String mediaType) {
        Mockito.when((Object)variableModel.getParameter("Variable", "key")).thenReturn((Object)((ComponentParameterAst)Mockito.mock(ComponentParameterAst.class)));
        Mockito.when((Object)variableModel.getParameter("Variable", "key").getValue()).thenReturn((Object)Either.right((Object)key));
        Mockito.when((Object)variableModel.getParameter("Variable", "value")).thenReturn((Object)((ComponentParameterAst)Mockito.mock(ComponentParameterAst.class)));
        Mockito.when((Object)variableModel.getParameter("Variable", "value").getValue()).thenReturn((Object)Either.right((Object)value));
        Mockito.when((Object)variableModel.getParameter("Variable", "mediaType")).thenReturn((Object)((ComponentParameterAst)Mockito.mock(ComponentParameterAst.class)));
        Mockito.when((Object)variableModel.getParameter("Variable", "mediaType").getValue()).thenReturn((Object)Either.right((Object)mediaType));
    }

    @Test
    public void testParseVariables() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        List<ComponentAst> componentModels = Arrays.asList(this.createMockComponentAst("var1", "value1", "text/plain"), this.createMockComponentAst("var2", "value2", "application/json"));
        Method method = MUnitSetEventParser.class.getDeclaredMethod("parseVariables", List.class, MuleEventExprBuilder.class);
        method.setAccessible(true);
        Assert.assertNull((Object)method.invoke((Object)this.parser, componentModels, this.muleEventExprBuilder));
        ((MuleEventExprBuilder)Mockito.verify((Object)this.muleEventExprBuilder, (VerificationMode)Mockito.times((int)2))).variable(Mockito.anyString(), (Consumer)Mockito.any());
        ((MuleEventExprBuilder)Mockito.verify((Object)this.muleEventExprBuilder)).variable((String)Mockito.eq((Object)"var1"), (Consumer)Mockito.any());
        ((MuleEventExprBuilder)Mockito.verify((Object)this.muleEventExprBuilder)).variable((String)Mockito.eq((Object)"var2"), (Consumer)Mockito.any());
    }

    private ComponentAst createMockComponentAst(String key, String value, String mediaType) {
        ComponentAst componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentParameterAst keyParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)keyParam.getValue()).thenReturn((Object)Either.right((Object)key));
        Mockito.when((Object)componentAst.getParameter("Variable", "key")).thenReturn((Object)keyParam);
        ComponentParameterAst valueParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)valueParam.getValue()).thenReturn((Object)Either.right((Object)value));
        Mockito.when((Object)componentAst.getParameter("Variable", "value")).thenReturn((Object)valueParam);
        ComponentParameterAst mediaTypeParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)mediaTypeParam.getValue()).thenReturn((Object)Either.right((Object)mediaType));
        Mockito.when((Object)componentAst.getParameter("Variable", "mediaType")).thenReturn((Object)mediaTypeParam);
        return componentAst;
    }
}

