/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class AnnotationSupport<A> {
    private final Map<Class<? extends A>, A> annotationsMap = new LinkedHashMap<Class<? extends A>, A>();

    public Set<A> getAnnotations() {
        return new LinkedHashSet<A>(this.annotationsMap.values());
    }

    public <T extends A> Optional<T> getAnnotation(Class<T> annotationClass) {
        Preconditions.checkNotNull(annotationClass);
        return Optional.ofNullable(this.annotationsMap.get(annotationClass));
    }

    public <T extends A> void annotate(T annotation) {
        Preconditions.checkNotNull(annotation);
        Preconditions.checkState((!this.annotationsMap.containsKey(annotation) ? 1 : 0) != 0, (Object)"annotation already present");
        this.annotationsMap.put(annotation.getClass(), annotation);
    }

    public <T extends A> Optional<T> deannotate(Class<T> annotation) {
        Preconditions.checkNotNull(annotation);
        return Optional.ofNullable(this.annotationsMap.remove(annotation));
    }

    public <T extends A> boolean isAnnotatedWith(Class<T> annotationClass) {
        return this.annotationsMap.containsKey(annotationClass);
    }

    public <T extends A> T getOrCreateAnnotation(Class<T> annotationClass, Supplier<T> supplier) {
        return (T)this.getAnnotation(annotationClass).orElseGet(() -> {
            Object annotation = supplier.get();
            this.annotate(annotation);
            return annotation;
        });
    }
}

