/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util.bindings;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.util.bindings.TypeBindingUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.message.api.el.ModuleDefinition;
import org.mule.metadata.message.api.el.TypeBindings;

public class TypeBindingUtilsTest {
    private void verify(TypeBindings.Builder typeBindingsBuilder) {
        TypeBindings typeBindings = typeBindingsBuilder != null ? typeBindingsBuilder.build() : null;
        TypeBindings newTypeBindings = TypeBindingUtils.fromMap((Map)TypeBindingUtils.toMap((TypeBindings)typeBindings));
        Assert.assertEquals((Object)TypeBindingUtils.toString((TypeBindings)typeBindings), (Object)TypeBindingUtils.toString((TypeBindings)newTypeBindings));
    }

    @Test
    public void test_00() {
        TypeBindings.Builder builder = TypeBindings.builder();
        this.verify(builder);
    }

    @Test
    public void test_01() {
        this.verify(null);
    }

    @Test
    public void test_02() {
        TypeBindings.Builder builder = TypeBindings.builder();
        DefaultStringType stringType = TypesHelper.getTypeBuilder().stringType().build();
        builder.addBinding("f1_1", (MetadataType)stringType);
        builder.addBinding("f1_2", (MetadataType)stringType);
        this.verify(builder);
    }

    @Test
    public void test_03() {
        TypeBindings.Builder builder = TypeBindings.builder();
        ModuleDefinition.Builder mod1 = builder.module("mod1");
        DefaultStringType stringType = TypesHelper.getTypeBuilder().stringType().build();
        mod1.addElement("f1_1", (MetadataType)stringType);
        mod1.addElement("f1_2", (MetadataType)stringType);
        ModuleDefinition.Builder mod2 = builder.module("mod2");
        mod2.addElement("f2_1", (MetadataType)stringType);
        this.verify(builder);
    }

    @Test
    public void test_04() {
        TypeBindings.Builder builder = TypeBindings.builder();
        DefaultStringType stringType = TypesHelper.getTypeBuilder().stringType().build();
        builder.addBinding("f1", (MetadataType)stringType);
        builder.addBinding("f2", (MetadataType)stringType);
        ModuleDefinition.Builder mod1 = builder.module("mod1");
        mod1.addElement("f1_1", (MetadataType)stringType);
        mod1.addElement("f1_2", (MetadataType)stringType);
        ModuleDefinition.Builder mod2 = builder.module("mod2");
        mod2.addElement("f2_1", (MetadataType)stringType);
        this.verify(builder);
    }
}

