/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.impl.model.annotations.ComponentLocationAnnotation;
import org.mule.datasense.impl.model.annotations.metadata.SourceModelAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.annotators.DynamicSourceAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.ast.api.ComponentAst;

public class DynamicSourceAnnotatorTest {
    @Mock
    private MessageProcessorNode messageProcessorNode;
    @Mock
    private DataSenseMetadataProvider dataSenseMetadataProvider;
    @Mock
    private ComponentLocationAnnotation componentLocationAnnotation;
    @Mock
    private AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext;
    @Mock
    private ComponentAst componentModel;
    @Mock
    private MetadataResult<SourceModel> metadataResult;
    @Mock
    private SourceModel sourceModel;
    @Mock
    private AstNodeLocation astNodeLocation;
    private DynamicSourceAnnotator dynamicSourceAnnotator;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.dynamicSourceAnnotator = new DynamicSourceAnnotator();
    }

    @Test
    public void testResolveMetadataSuccess() {
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentModel);
        Mockito.when((Object)this.dataSenseMetadataProvider.getSourceMetadata(this.componentModel)).thenReturn(this.metadataResult);
        Mockito.when((Object)this.metadataResult.isSuccess()).thenReturn((Object)true);
        Mockito.when((Object)((SourceModel)this.metadataResult.get())).thenReturn((Object)this.sourceModel);
        this.dynamicSourceAnnotator.resolveMetadata(this.messageProcessorNode, this.dataSenseMetadataProvider, this.componentLocationAnnotation, this.annotatingMuleAstVisitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((SourceModelAnnotation)Mockito.any(SourceModelAnnotation.class)));
    }

    @Test
    public void testResolveMetadataFailure() {
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentModel);
        Mockito.when((Object)this.dataSenseMetadataProvider.getSourceMetadata(this.componentModel)).thenReturn(this.metadataResult);
        Mockito.when((Object)this.metadataResult.isSuccess()).thenReturn((Object)false);
        this.dynamicSourceAnnotator.resolveMetadata(this.messageProcessorNode, this.dataSenseMetadataProvider, this.componentLocationAnnotation, this.annotatingMuleAstVisitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).annotate((AstNodeAnnotation)((SourceModelAnnotation)Mockito.any(SourceModelAnnotation.class)));
    }

    @Test
    public void testResolveMetadataNull() {
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentModel);
        Mockito.when((Object)this.dataSenseMetadataProvider.getSourceMetadata(this.componentModel)).thenReturn(null);
        Mockito.when((Object)this.messageProcessorNode.getAstNodeLocation()).thenReturn((Object)this.astNodeLocation);
        Mockito.when((Object)this.componentLocationAnnotation.getLocation()).thenReturn((Object)((Location)Mockito.mock(Location.class)));
        Mockito.when((Object)this.annotatingMuleAstVisitorContext.getAstNotification()).thenReturn((Object)((AstNotification)Mockito.mock(AstNotification.class)));
        this.dynamicSourceAnnotator.resolveMetadata(this.messageProcessorNode, this.dataSenseMetadataProvider, this.componentLocationAnnotation, this.annotatingMuleAstVisitorContext);
        ((AstNotification)Mockito.verify((Object)this.annotatingMuleAstVisitorContext.getAstNotification())).reportError((AstNodeLocation)Mockito.eq((Object)this.astNodeLocation), (I18nMessage)Mockito.any());
    }
}

