/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.api.metadataprovider;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.api.metadataprovider.DataSenseConfiguration;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.api.metadataprovider.DefaultDataSenseProvider;
import org.mule.datasenseapi.api.metadataprovider.ExtensionsProvider;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.apikit.metadata.api.MetadataBuilder;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultDataSenseProviderTest {
    @Mock
    private ExtensionsProvider extensionsProvider;
    @Mock
    private DataSenseMetadataProvider dataSenseMetadataProvider;
    @Mock
    private DataSenseConfiguration dataSenseConfiguration;
    @Mock
    private ExpressionLanguageMetadataService expressionLanguageMetadataService;
    @Mock
    private MetadataBuilder apikitMetadataBuilder;
    private DefaultDataSenseProvider defaultDataSenseProvider;

    @Before
    public void setUp() {
        this.defaultDataSenseProvider = new DefaultDataSenseProvider(this.extensionsProvider, this.dataSenseMetadataProvider, this.dataSenseConfiguration, this.expressionLanguageMetadataService, this.apikitMetadataBuilder);
    }

    @Test
    public void testGetExtensions() {
        HashSet expectedExtensions = new HashSet();
        Mockito.when((Object)this.extensionsProvider.getExtensions()).thenReturn(expectedExtensions);
        Set actualExtensions = this.defaultDataSenseProvider.getExtensions();
        Assert.assertEquals(expectedExtensions, (Object)actualExtensions);
        ((ExtensionsProvider)Mockito.verify((Object)this.extensionsProvider)).getExtensions();
    }

    @Test
    public void testGetDataSenseMetadataProvider() {
        Optional result = this.defaultDataSenseProvider.getDataSenseMetadataProvider();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)this.dataSenseMetadataProvider, result.get());
    }

    @Test
    public void testGetApikitMetadataBuilder() {
        MetadataBuilder result = this.defaultDataSenseProvider.getApikitMetadataBuilder();
        Assert.assertEquals((Object)this.apikitMetadataBuilder, (Object)result);
    }

    @Test
    public void testGetDataSenseConfiguration() {
        Optional result = this.defaultDataSenseProvider.getDataSenseConfiguration();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)this.dataSenseConfiguration, result.get());
    }

    @Test
    public void testGetExpressionLanguageMetadataService() {
        ExpressionLanguageMetadataService result = this.defaultDataSenseProvider.getExpressionLanguageMetadataService();
        Assert.assertEquals((Object)this.expressionLanguageMetadataService, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorWithNullExtensionsProvider() {
        new DefaultDataSenseProvider(null, this.dataSenseMetadataProvider, this.dataSenseConfiguration, this.expressionLanguageMetadataService, this.apikitMetadataBuilder);
    }

    @Test
    public void testGetDataSenseMetadataProviderWhenNull() {
        DefaultDataSenseProvider providerWithNullMetadataProvider = new DefaultDataSenseProvider(this.extensionsProvider, null, this.dataSenseConfiguration, this.expressionLanguageMetadataService, this.apikitMetadataBuilder);
        Optional result = providerWithNullMetadataProvider.getDataSenseMetadataProvider();
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testGetDataSenseConfigurationWhenNull() {
        DefaultDataSenseProvider providerWithNullConfiguration = new DefaultDataSenseProvider(this.extensionsProvider, this.dataSenseMetadataProvider, null, this.expressionLanguageMetadataService, this.apikitMetadataBuilder);
        Optional result = providerWithNullConfiguration.getDataSenseConfiguration();
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testPerform() {
        Optional result = this.defaultDataSenseProvider.getDataSenseConfiguration();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)this.dataSenseConfiguration, result.get());
    }
}

