/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.model.annotations.GlobalBindingsAnnotation;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.phases.annotators.Annotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.GlobalBindingMetadataTypes;
import org.mule.metadata.message.api.el.TypeBindings;

public class GlobalBindingsAnnotator
implements Annotator {
    @Override
    public void annotate(MuleApplicationNode muleApplicationNode, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
        this.registerGlobalBindings(muleApplicationNode, annotatingMuleAstVisitorContext);
    }

    private void registerGlobalBindings(MuleApplicationNode muleApplicationNode, AnnotatingMuleAstVisitorContext visitorContext) {
        TypeBindings.Builder typeBindingsBuilder = TypeBindings.builder();
        GlobalBindingMetadataTypes globalBindingMetadataTypes = visitorContext.getDataSenseProviderResolver().getGlobalBindingMetadataTypes();
        typeBindingsBuilder.addBinding("mule", globalBindingMetadataTypes.muleType());
        typeBindingsBuilder.addBinding("server", globalBindingMetadataTypes.serverType());
        typeBindingsBuilder.addBinding("app", globalBindingMetadataTypes.appType());
        typeBindingsBuilder.addBinding("flow", globalBindingMetadataTypes.flowType());
        typeBindingsBuilder.addBinding("correlationId", globalBindingMetadataTypes.correlationIdType());
        typeBindingsBuilder.addBinding("authentication", globalBindingMetadataTypes.authenticationType());
        typeBindingsBuilder.addBinding("dataType", globalBindingMetadataTypes.dataTypeType());
        typeBindingsBuilder.addBinding("itemSequenceInfo", globalBindingMetadataTypes.itemSequenceInfoType());
        typeBindingsBuilder.addBinding("error", globalBindingMetadataTypes.errorType());
        TypeBindings typeBindings = typeBindingsBuilder.build();
        muleApplicationNode.annotate(new GlobalBindingsAnnotation(globalBindingMetadataTypes, typeBindings));
    }
}

