/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MuleAstParseProvider;
import org.mule.datasense.impl.phases.builder.MuleAstParserContext;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitor;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitorContext;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.ForEachTypeResolver;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultAnyType;
import org.mule.metadata.api.model.impl.DefaultArrayType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

public class ForEachTypeResolverTest {
    private ForEachTypeResolver resolver;
    private MessageProcessorNode messageProcessorNode;
    private ComponentAst componentModel;
    private TypingMuleAstVisitor typingMuleAstVisitor;
    private TypingMuleAstVisitorContext typingMuleAstVisitorContext;
    private ForEachTypeResolver.ForEachScopeIn scopeIn;

    @Before
    public void setUp() {
        this.resolver = new ForEachTypeResolver();
        this.scopeIn = new ForEachTypeResolver.ForEachScopeIn();
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.componentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.typingMuleAstVisitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);
        this.typingMuleAstVisitorContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentModel);
    }

    @Test
    public void testIsBatchModeFalse() {
        boolean result = ForEachTypeResolver.isBatchMode((ComponentAst)this.componentModel);
        Assert.assertFalse((String)"Batch mode should be enabled when batchSize > 1", (boolean)result);
    }

    @Test
    public void testIsBatchMode_GreaterThanOne() {
        ParameterizedModel constructModelMock = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ComponentParameterAst parameterModelMock = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        ConstructModel constructModel = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)this.componentModel.getModel(ParameterizedModel.class)).thenReturn(Optional.of(constructModelMock));
        Mockito.when((Object)constructModelMock.getName()).thenReturn((Object)"foreach");
        Mockito.when((Object)this.componentModel.getParameter(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)parameterModelMock);
        Mockito.when((Object)parameterModelMock.getValue()).thenReturn((Object)Either.right((Object)2));
        Mockito.when((Object)this.componentModel.getModel(ConstructModel.class)).thenReturn(Optional.of(constructModel));
        Mockito.when((Object)constructModel.getName()).thenReturn((Object)"foreach");
        Mockito.when((Object)constructModelMock.getName()).thenReturn((Object)"foreach");
        boolean result = ForEachTypeResolver.isBatchMode((ComponentAst)this.componentModel);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testBuildInnerPayloadType() {
        DefaultArrayType arrayType = (DefaultArrayType)Mockito.mock(DefaultArrayType.class);
        Mockito.when((Object)arrayType.getType()).thenReturn((Object)((MetadataType)Mockito.mock(MetadataType.class)));
        Optional result = ForEachTypeResolver.buildInnerPayloadType((MetadataType)arrayType);
        Assert.assertTrue((boolean)result.isPresent());
    }

    @Test
    public void testBuildInnerPayloadType_AnyType() {
        DefaultAnyType anyType = (DefaultAnyType)Mockito.mock(DefaultAnyType.class);
        Optional result = ForEachTypeResolver.buildInnerPayloadType((MetadataType)anyType);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testBuildInnerPayloadType_ObjectType_Empty() {
        DefaultObjectType objectType = (DefaultObjectType)Mockito.mock(DefaultObjectType.class);
        Optional result = ForEachTypeResolver.buildInnerPayloadType((MetadataType)objectType);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testBuildInnerPayloadType_ObjectType_Size1() {
        DefaultObjectType objectType = (DefaultObjectType)Mockito.mock(DefaultObjectType.class);
        ObjectFieldType fieldType = (ObjectFieldType)Mockito.mock(ObjectFieldType.class);
        ObjectFieldType fieldType1 = (ObjectFieldType)Mockito.mock(ObjectFieldType.class);
        Mockito.when((Object)fieldType.getValue()).thenReturn((Object)((MetadataType)Mockito.mock(MetadataType.class)));
        Mockito.when((Object)fieldType1.getValue()).thenReturn((Object)((MetadataType)Mockito.mock(MetadataType.class)));
        Mockito.when((Object)objectType.getFields()).thenReturn(Arrays.asList(fieldType, fieldType1));
        Optional result = ForEachTypeResolver.buildInnerPayloadType((MetadataType)objectType);
        Assert.assertTrue((boolean)result.isPresent());
    }

    @Test
    public void testGetCollectionExpression() {
        ComponentParameterAst componentParameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel().getParameter(Mockito.anyString(), (String)Mockito.eq((Object)"collection"))).thenReturn((Object)componentParameterAst);
        Mockito.when((Object)componentParameterAst.getValue()).thenReturn((Object)((Either)Mockito.mock(Either.class)));
        Assert.assertNotNull((String)"payload", (Object)ForEachTypeResolver.getCollectionExpression((MessageProcessorNode)this.messageProcessorNode));
    }

    @Test
    public void testResolve() {
        EventType inputEventType = (EventType)Mockito.mock(EventType.class);
        EventType outputEventType = this.resolver.resolve(this.messageProcessorNode, inputEventType, this.typingMuleAstVisitor, this.typingMuleAstVisitorContext);
        Assert.assertNotNull((Object)outputEventType);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)Mockito.any());
    }

    @Test
    public void testGetComponentModelType() {
        Assert.assertTrue((boolean)this.resolver.getComponentModelType().isPresent());
    }

    @Test
    public void testGetParseProvider() {
        Optional optional = this.resolver.getParseProvider();
        ComponentIdentifier componentIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        ArrayList messageProcessorNodeBuilders = new ArrayList();
        MuleAstParserContext muleAstParserContext = (MuleAstParserContext)Mockito.mock(MuleAstParserContext.class);
        Optional astParseProvider = ((MuleAstParseProvider)optional.get()).parse(componentIdentifier, this.componentModel, ComponentModelType.MESSAGE_PROCESSOR_NODE, messageProcessorNodeBuilders, muleAstParserContext);
        Assert.assertNotNull(astParseProvider.get());
    }

    @Test
    public void testIsScope() {
        Assert.assertTrue((boolean)this.resolver.isScope());
    }

    @Test
    public void testBuildInnerEventType() {
        EventType eventType = (EventType)Mockito.mock(EventType.class);
        Either either = (Either)Mockito.mock(Either.class);
        ComponentParameterAst componentParameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel().getParameter(Mockito.anyString(), (String)Mockito.eq((Object)"collection"))).thenReturn((Object)componentParameterAst);
        Mockito.when((Object)componentParameterAst.getValue()).thenReturn((Object)either);
        Mockito.when((Object)either.mapLeft((Function)Mockito.any())).thenReturn((Object)((Either)Mockito.mock(Either.class)));
        Mockito.when((Object)this.typingMuleAstVisitorContext.getTypeBindings()).thenReturn((Object)((TypeBindings)Mockito.mock(TypeBindings.class)));
        Mockito.when((Object)this.typingMuleAstVisitorContext.getExpressionLanguageMetadataService()).thenReturn((Object)((ExpressionLanguageMetadataService)Mockito.mock(ExpressionLanguageMetadataService.class)));
        Assert.assertNotNull((Object)ForEachTypeResolver.buildInnerEventType((MessageProcessorNode)this.messageProcessorNode, (EventType)eventType, (TypingMuleAstVisitorContext)this.typingMuleAstVisitorContext, (String)"defaultCounterVariableName"));
    }

    @Test
    public void testResolveExpectedInputEventType() {
        EventType eventType = (EventType)Mockito.mock(EventType.class);
        ExpectedAstVisitor expectedAstVisitor = (ExpectedAstVisitor)Mockito.mock(ExpectedAstVisitor.class);
        ExpectedAstVisitorContext visitorContext = (ExpectedAstVisitorContext)Mockito.mock(ExpectedAstVisitorContext.class);
        ComponentParameterAst parameterModelMock = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        VarDecl varDecl = (VarDecl)Mockito.mock(VarDecl.class);
        Mockito.when((Object)eventType.get("#payload#")).thenReturn(Optional.of(varDecl));
        VarDecl varDeclAttr = (VarDecl)Mockito.mock(VarDecl.class);
        Mockito.when((Object)eventType.get("#attributes#")).thenReturn(Optional.of(varDeclAttr));
        Mockito.when((Object)this.componentModel.getParameter(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)parameterModelMock);
        Mockito.when((Object)parameterModelMock.getValue()).thenReturn((Object)Either.left((Object)"payload"));
        this.resolver.resolveExpectedInputEventType(eventType, this.messageProcessorNode, expectedAstVisitor, visitorContext);
        Assert.assertNotNull((Object)this.componentModel.getParameter("A", "B"));
    }

    @Test
    public void testResolveInner() {
        ComponentParameterAst componentParameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        Mockito.when((Object)this.messageProcessorNode.getComponentModel().getParameter(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)componentParameterAst);
        Mockito.when((Object)componentParameterAst.getValue()).thenReturn((Object)Either.left((Object)"leftVal"));
        Mockito.when((Object)this.typingMuleAstVisitorContext.getTypeBindings()).thenReturn((Object)TypeBindings.builder().build());
        Mockito.when((Object)this.typingMuleAstVisitorContext.getExpressionLanguageMetadataService()).thenReturn((Object)((ExpressionLanguageMetadataService)Mockito.mock(ExpressionLanguageMetadataService.class)));
        EventType eventType = this.scopeIn.resolve(this.messageProcessorNode, (EventType)Mockito.mock(EventType.class), this.typingMuleAstVisitor, this.typingMuleAstVisitorContext);
        Assert.assertNotNull((Object)eventType);
    }
}

