/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util;

import java.util.Arrays;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.model.annotations.ComponentLocationAnnotation;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.ExpectedEventAnnotation;
import org.mule.datasense.impl.model.annotations.IncomingEventAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.util.DisplayMuleAstVisitor;
import org.mule.datasense.impl.util.DisplayMuleAstVisitorContext;
import org.mule.datasense.impl.util.TreeLogSupport;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;

@RunWith(value=MockitoJUnitRunner.class)
public class DisplayMuleAstVisitorTest {
    private DisplayMuleAstVisitor visitor;
    @Mock
    private DisplayMuleAstVisitorContext context;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        MetadataType metadataType = (MetadataType)Mockito.mock(MetadataType.class);
        TreeLogSupport logSupport = (TreeLogSupport)Mockito.mock(TreeLogSupport.class);
        MetadataFormat format = (MetadataFormat)Mockito.mock(MetadataFormat.class);
        this.visitor = new DisplayMuleAstVisitor();
        Mockito.when((Object)this.context.logger()).thenReturn((Object)logSupport);
    }

    @Test
    public void testVisitMuleApplicationNode() {
        MuleApplicationNode applicationNode = (MuleApplicationNode)Mockito.mock(MuleApplicationNode.class);
        MuleFlowNode flowNode1 = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        MuleFlowNode flowNode2 = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        Mockito.when((Object)applicationNode.getName()).thenReturn((Object)"TestApplication");
        Mockito.when((Object)applicationNode.getMuleFlowNodes()).thenReturn(Arrays.asList(flowNode1, flowNode2).stream());
        this.visitor.visit(applicationNode, this.context);
        ((MuleFlowNode)Mockito.verify((Object)flowNode1)).accept((AstNodeVisitor)this.visitor, (Object)this.context);
        ((MuleFlowNode)Mockito.verify((Object)flowNode2)).accept((AstNodeVisitor)this.visitor, (Object)this.context);
    }

    @Test
    public void testVisitMuleFlowNode() {
        MuleFlowNode flowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        MessageProcessorNode processorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)flowNode.getName()).thenReturn((Object)"TestFlow");
        Mockito.when((Object)flowNode.getRootMessageProcessorNode()).thenReturn(Optional.of(processorNode));
        this.visitor.visit(flowNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)processorNode)).accept((AstNodeVisitor)this.visitor, (Object)this.context);
    }

    @Test
    public void testVisitMessageProcessorNode() {
        MessageProcessorNode processorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        ComponentIdentifier identifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        ComponentLocationAnnotation locationAnnotation = (ComponentLocationAnnotation)Mockito.mock(ComponentLocationAnnotation.class);
        UsesTypeAnnotation usesAnnotation = (UsesTypeAnnotation)Mockito.mock(UsesTypeAnnotation.class);
        DefinesTypeAnnotation definesAnnotation = (DefinesTypeAnnotation)Mockito.mock(DefinesTypeAnnotation.class);
        IncomingEventAnnotation incomingAnnotation = (IncomingEventAnnotation)Mockito.mock(IncomingEventAnnotation.class);
        ExpectedEventAnnotation expectedAnnotation = (ExpectedEventAnnotation)Mockito.mock(ExpectedEventAnnotation.class);
        EventType eventType = (EventType)Mockito.mock(EventType.class);
        Mockito.when((Object)processorNode.getComponentIdentifier()).thenReturn((Object)identifier);
        Mockito.when((Object)identifier.toString()).thenReturn((Object)"TestProcessor");
        Mockito.when((Object)processorNode.getAnnotation(ComponentLocationAnnotation.class)).thenReturn(Optional.of(locationAnnotation));
        Mockito.when((Object)processorNode.getAnnotation(UsesTypeAnnotation.class)).thenReturn(Optional.of(usesAnnotation));
        Mockito.when((Object)processorNode.getAnnotation(DefinesTypeAnnotation.class)).thenReturn(Optional.of(definesAnnotation));
        Mockito.when((Object)processorNode.getAnnotation(IncomingEventAnnotation.class)).thenReturn(Optional.of(incomingAnnotation));
        Mockito.when((Object)processorNode.getAnnotation(ExpectedEventAnnotation.class)).thenReturn(Optional.of(expectedAnnotation));
        Mockito.when((Object)usesAnnotation.getUsesEventType()).thenReturn((Object)eventType);
        Mockito.when((Object)definesAnnotation.getDefinesEventType()).thenReturn((Object)eventType);
        Mockito.when((Object)incomingAnnotation.getEventType()).thenReturn((Object)eventType);
        Mockito.when((Object)expectedAnnotation.getEventType()).thenReturn((Object)eventType);
        this.visitor.visit(processorNode, this.context);
        Assert.assertNotNull((Object)identifier);
    }

    @Test
    public void testVisitMessageProcessorNodeWithNestedNodes() {
        MessageProcessorNode parentNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        MessageProcessorNode childNode1 = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        MessageProcessorNode childNode2 = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        ComponentIdentifier identifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        Mockito.when((Object)parentNode.getComponentIdentifier()).thenReturn((Object)identifier);
        Mockito.when((Object)identifier.toString()).thenReturn((Object)"ParentProcessor");
        Mockito.when((Object)parentNode.getMessageProcessorNodes()).thenReturn(Arrays.asList(childNode1, childNode2).stream());
        this.visitor.visit(parentNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)childNode1)).accept((AstNodeVisitor)this.visitor, (Object)this.context);
        ((MessageProcessorNode)Mockito.verify((Object)childNode2)).accept((AstNodeVisitor)this.visitor, (Object)this.context);
    }
}

