/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.ast2.test.utils;

import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;

public class TypeUtilsTest {
    @Test
    public void mergeOverridesSameDeclarationWithSecondEvent() {
        EventType eventType2;
        EventType eventType1 = new EventType(Stream.of(new VarDecl("v1", (MetadataType)TypesHelper.getTypeBuilder().stringType().build())));
        EventType result = TypeUtils.merge((EventType)eventType1, (EventType)(eventType2 = new EventType(Stream.of(new VarDecl("v1", (MetadataType)TypesHelper.getTypeBuilder().booleanType().build())))));
        Assert.assertTrue((result.getVarDecls().count() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.get("v1").isPresent());
        Assert.assertThat((Object)((VarDecl)result.get("v1").get()).getType(), (Matcher)CoreMatchers.instanceOf(BooleanType.class));
    }

    @Test
    public void mergeAddsDisjointDeclarations() {
        EventType eventType2;
        EventType eventType1 = new EventType(Stream.of(new VarDecl("v1", (MetadataType)TypesHelper.getTypeBuilder().stringType().build())));
        EventType result = TypeUtils.merge((EventType)eventType1, (EventType)(eventType2 = new EventType(Stream.of(new VarDecl("v2", (MetadataType)TypesHelper.getTypeBuilder().booleanType().build())))));
        Assert.assertTrue((result.getVarDecls().count() == 2L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.get("v1").isPresent());
        Assert.assertThat((Object)((VarDecl)result.get("v1").get()).getType(), (Matcher)CoreMatchers.instanceOf(StringType.class));
        Assert.assertTrue((boolean)result.get("v2").isPresent());
        Assert.assertThat((Object)((VarDecl)result.get("v2").get()).getType(), (Matcher)CoreMatchers.instanceOf(BooleanType.class));
    }

    @Test
    public void mergeOfEmptyIsEmpty() {
        EventType eventType2;
        EventType eventType1 = new EventType(Stream.empty());
        EventType result = TypeUtils.merge((EventType)eventType1, (EventType)(eventType2 = new EventType(Stream.empty())));
        Assert.assertTrue((result.getVarDecls().count() == 0L ? 1 : 0) != 0);
    }
}

