/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.phases.annotators.Annotator;
import org.mule.datasense.impl.phases.annotators.BaseCompositeAnnotator;

@RunWith(value=MockitoJUnitRunner.class)
public class BaseCompositeAnnotatorTest {
    @Mock
    private Annotator annotator1;
    @Mock
    private Annotator annotator2;
    private TestCompositeAnnotator compositeAnnotator;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.compositeAnnotator = new TestCompositeAnnotator(Stream.of(this.annotator1, this.annotator2));
    }

    @Test
    public void testConstructor() {
        List<Annotator> annotators = this.compositeAnnotator.getAnnotatorsList();
        Assert.assertEquals((long)2L, (long)annotators.size());
        Assert.assertTrue((boolean)annotators.contains(this.annotator1));
        Assert.assertTrue((boolean)annotators.contains(this.annotator2));
    }

    @Test
    public void testGetAnnotators() {
        Stream annotatorStream = this.compositeAnnotator.getAnnotators();
        List annotators = annotatorStream.collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)annotators.size());
        Assert.assertTrue((boolean)annotators.contains(this.annotator1));
        Assert.assertTrue((boolean)annotators.contains(this.annotator2));
    }

    @Test
    public void testConstructorWithEmptyStream() {
        TestCompositeAnnotator emptyCompositeAnnotator = new TestCompositeAnnotator(Stream.empty());
        Assert.assertTrue((boolean)emptyCompositeAnnotator.getAnnotatorsList().isEmpty());
    }

    @Test
    public void testConstructorWithLargeNumberOfAnnotators() {
        int annotatorCount = 1000;
        Stream<Annotator> largeStream = Stream.generate(() -> (Annotator)Mockito.mock(Annotator.class)).limit(annotatorCount);
        TestCompositeAnnotator largeCompositeAnnotator = new TestCompositeAnnotator(largeStream);
        Assert.assertEquals((long)annotatorCount, (long)largeCompositeAnnotator.getAnnotatorsList().size());
    }

    private static class TestCompositeAnnotator
    extends BaseCompositeAnnotator {
        public TestCompositeAnnotator(Stream<Annotator> annotators) {
            super(annotators);
        }

        public void annotate() {
        }

        public List<Annotator> getAnnotatorsList() {
            return this.getAnnotators().collect(Collectors.toList());
        }
    }
}

