/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.datasense.impl.model.types.TypeAssignability;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BooleanTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.MetadataType;

@RunWith(value=Parameterized.class)
public class TypeEqualityTest {
    private final MetadataType sourceType;
    private final MetadataType targetType;
    private final boolean expected;
    private final String name;

    public TypeEqualityTest(TypeBuilder sourceType, TypeBuilder targetType, boolean expected, String name) {
        this.sourceType = sourceType.build();
        this.targetType = targetType.build();
        this.expected = expected;
        this.name = name;
    }

    @Test
    public void assignableTest() {
        Assert.assertEquals((Object)this.expected, (Object)TypeAssignability.isEqual((MetadataType)this.sourceType, (MetadataType)this.targetType, null));
    }

    private static List<Object[]> unionEqualityTests() {
        String name = "union-equality-test";
        UnionTypeBuilder sourceUnionTypeBuilder1 = TypesHelper.getTypeBuilder().unionType();
        sourceUnionTypeBuilder1.of().numberType();
        UnionTypeBuilder sourceUnionTypeBuilder2 = TypesHelper.getTypeBuilder().unionType();
        sourceUnionTypeBuilder2.of().numberType();
        sourceUnionTypeBuilder2.of().stringType();
        UnionTypeBuilder sourceUnionTypeBuilder3 = TypesHelper.getTypeBuilder().unionType();
        sourceUnionTypeBuilder3.of().stringType();
        UnionTypeBuilder sourceUnionTypeBuilder4 = TypesHelper.getTypeBuilder().unionType();
        sourceUnionTypeBuilder4.of().stringType();
        sourceUnionTypeBuilder4.of().numberType();
        UnionTypeBuilder sourceUnionTypeBuilder51 = TypesHelper.getTypeBuilder().unionType();
        sourceUnionTypeBuilder51.of().numberType();
        UnionTypeBuilder sourceUnionTypeBuilder52 = TypesHelper.getTypeBuilder().unionType();
        sourceUnionTypeBuilder52.of().stringType();
        UnionTypeBuilder sourceUnionTypeBuilder5 = TypesHelper.getTypeBuilder().unionType();
        sourceUnionTypeBuilder5.of((TypeBuilder)sourceUnionTypeBuilder51);
        sourceUnionTypeBuilder5.of((TypeBuilder)sourceUnionTypeBuilder52);
        UnionTypeBuilder sourceUnionTypeBuilder6 = TypesHelper.getTypeBuilder().unionType();
        sourceUnionTypeBuilder6.of().numberType();
        sourceUnionTypeBuilder6.of().stringType();
        sourceUnionTypeBuilder6.of().stringType();
        sourceUnionTypeBuilder6.of().numberType();
        return Arrays.asList({sourceUnionTypeBuilder1, sourceUnionTypeBuilder1, Boolean.TRUE, name}, {sourceUnionTypeBuilder2, sourceUnionTypeBuilder2, Boolean.TRUE, name}, {sourceUnionTypeBuilder2, sourceUnionTypeBuilder4, Boolean.TRUE, name}, {sourceUnionTypeBuilder1, sourceUnionTypeBuilder2, Boolean.FALSE, name}, {sourceUnionTypeBuilder1, sourceUnionTypeBuilder3, Boolean.FALSE, name}, {sourceUnionTypeBuilder2, sourceUnionTypeBuilder5, Boolean.TRUE, name}, {sourceUnionTypeBuilder2, sourceUnionTypeBuilder6, Boolean.TRUE, name});
    }

    private static List<Object[]> objectEqualityTests() {
        String name = "object-equality-test";
        StringTypeBuilder stringTypeBuilder = TypesHelper.getTypeBuilder().stringType();
        NumberTypeBuilder numberTypeBuilder = TypesHelper.getTypeBuilder().numberType();
        BooleanTypeBuilder booleanTypeBuilder = TypesHelper.getTypeBuilder().booleanType();
        ObjectTypeBuilder objectTypeBuilder0 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder0.addField().key("field1").value((TypeBuilder)stringTypeBuilder);
        ObjectTypeBuilder objectTypeBuilder1 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder1.addField().key("field1").value((TypeBuilder)stringTypeBuilder).required(true);
        objectTypeBuilder1.addField().key("field2").value((TypeBuilder)numberTypeBuilder).required(true);
        ObjectTypeBuilder objectTypeBuilder2 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder2.addField().key("field1").value((TypeBuilder)booleanTypeBuilder).required(true);
        ObjectTypeBuilder objectTypeBuilder3 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder3.addField().key("field1").value((TypeBuilder)stringTypeBuilder).required(false);
        objectTypeBuilder3.addField().key("field2").value((TypeBuilder)numberTypeBuilder).required(false);
        ObjectTypeBuilder objectTypeBuilder31 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder31.addField().key("field2").value((TypeBuilder)numberTypeBuilder).required(true);
        objectTypeBuilder31.addField().key("field1").value((TypeBuilder)stringTypeBuilder).required(true);
        ObjectTypeBuilder objectTypeBuilder32 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder32.addField().key("field1").value((TypeBuilder)stringTypeBuilder).required(false);
        objectTypeBuilder32.addField().key("field2").value((TypeBuilder)numberTypeBuilder).required(true);
        ObjectTypeBuilder objectTypeBuilder4 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder4.addField().key("field2").value((TypeBuilder)stringTypeBuilder).required(true);
        return Arrays.asList({objectTypeBuilder0, objectTypeBuilder0, Boolean.TRUE, name}, {objectTypeBuilder1, objectTypeBuilder1, Boolean.TRUE, name}, {objectTypeBuilder0, objectTypeBuilder2, Boolean.FALSE, name}, {objectTypeBuilder1, objectTypeBuilder3, Boolean.FALSE, name}, {objectTypeBuilder1, objectTypeBuilder31, Boolean.TRUE, name}, {objectTypeBuilder1, objectTypeBuilder32, Boolean.FALSE, name}, {objectTypeBuilder0, objectTypeBuilder4, Boolean.FALSE, name});
    }

    private static List<Object[]> arrayEqualityTests() {
        String name = "array-equality-test";
        StringTypeBuilder stringTypeBuilder = TypesHelper.getTypeBuilder().stringType();
        NumberTypeBuilder numberTypeBuilder = TypesHelper.getTypeBuilder().numberType();
        UnionTypeBuilder unionTypeBuilder0 = TypesHelper.getTypeBuilder().unionType();
        unionTypeBuilder0.of().numberType();
        ObjectTypeBuilder objectTypeBuilder0 = TypesHelper.getTypeBuilder().objectType();
        objectTypeBuilder0.addField().key("field1").value((TypeBuilder)stringTypeBuilder).required(true);
        ArrayTypeBuilder arrayTypeBuilder0 = TypesHelper.getTypeBuilder().arrayType();
        arrayTypeBuilder0.of((TypeBuilder)numberTypeBuilder);
        ArrayTypeBuilder arrayTypeBuilder1 = TypesHelper.getTypeBuilder().arrayType();
        arrayTypeBuilder1.of((TypeBuilder)stringTypeBuilder);
        ArrayTypeBuilder arrayTypeBuilder21 = TypesHelper.getTypeBuilder().arrayType();
        arrayTypeBuilder21.of((TypeBuilder)objectTypeBuilder0);
        return Arrays.asList({arrayTypeBuilder0, arrayTypeBuilder0, Boolean.TRUE, name}, {arrayTypeBuilder0, arrayTypeBuilder1, Boolean.FALSE, name}, {arrayTypeBuilder1, arrayTypeBuilder1, Boolean.TRUE, name}, {arrayTypeBuilder21, arrayTypeBuilder21, Boolean.TRUE, name});
    }

    @Parameterized.Parameters(name="{3}-{index}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.addAll(TypeEqualityTest.unionEqualityTests());
        parameters.addAll(TypeEqualityTest.objectEqualityTests());
        parameters.addAll(TypeEqualityTest.arrayEqualityTests());
        return parameters;
    }
}

