/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.munit;

import java.lang.reflect.Field;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.typing.resolver.ScopeTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.munit.MUnitBeforeTestTypeResolver;
import org.mule.runtime.api.component.ComponentIdentifier;

public class MUnitBeforeTestTypeResolverTest {
    private MUnitBeforeTestTypeResolver resolver;
    private ComponentIdentifier mockComponentIdentifierIn;
    private ComponentIdentifier mockComponentIdentifierOut;

    @Before
    public void setUp() {
        this.mockComponentIdentifierIn = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        this.mockComponentIdentifierOut = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        this.resolver = new MUnitBeforeTestTypeResolver(this.mockComponentIdentifierIn, this.mockComponentIdentifierOut);
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)this.resolver);
    }

    @Test
    public void testIsScope() {
        Assert.assertFalse((boolean)this.resolver.isScope());
    }

    @Test
    public void testIsPropagates() {
        MessageProcessorNode mockMessageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Assert.assertTrue((boolean)this.resolver.isPropagates(mockMessageProcessorNode));
    }

    @Test
    public void testInheritanceFromScopeTypeResolver() {
        Assert.assertTrue((boolean)(this.resolver instanceof ScopeTypeResolver));
    }

    @Test
    public void testComponentIdentifiersPassedToSuperConstructor() {
        try {
            Field inField = ScopeTypeResolver.class.getDeclaredField("componentIdentiferScopeIn");
            Field outField = ScopeTypeResolver.class.getDeclaredField("componentIdentiferScopeOut");
            inField.setAccessible(true);
            outField.setAccessible(true);
            Assert.assertEquals((Object)this.mockComponentIdentifierIn, (Object)inField.get(this.resolver));
            Assert.assertEquals((Object)this.mockComponentIdentifierOut, (Object)outField.get(this.resolver));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Assert.fail((String)("Failed to access superclass fields: " + e.getMessage()));
        }
    }
}

