/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.annotations.munit.MUnitDeclarationsAnnotation;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.phases.annotators.MUnitDeclarationAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.component.ComponentIdentifier;

public class MUnitDeclarationAnnotatorTest {
    private MUnitDeclarationAnnotator annotator;
    private AnnotatingMuleAstVisitorContext mockContext;
    private MuleApplicationNode mockAppNode;
    private MuleFlowNode mockFlowNode;
    private ComponentIdentifier mockIdentifier;
    private MUnitDeclarationsAnnotation mockMUnitDeclarations;

    @Before
    public void setUp() {
        this.annotator = new MUnitDeclarationAnnotator();
        this.mockContext = (AnnotatingMuleAstVisitorContext)Mockito.mock(AnnotatingMuleAstVisitorContext.class);
        this.mockAppNode = (MuleApplicationNode)Mockito.mock(MuleApplicationNode.class);
        this.mockFlowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        this.mockIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        this.mockMUnitDeclarations = (MUnitDeclarationsAnnotation)Mockito.mock(MUnitDeclarationsAnnotation.class);
        MuleApplicationAnnotation mockAppAnnotation = (MuleApplicationAnnotation)Mockito.mock(MuleApplicationAnnotation.class);
        Mockito.when((Object)mockAppAnnotation.getMuleApplicationNode()).thenReturn((Object)this.mockAppNode);
        Mockito.when((Object)this.mockContext.getAnnotation(MuleApplicationAnnotation.class)).thenReturn(Optional.of(mockAppAnnotation));
        Mockito.when((Object)((MUnitDeclarationsAnnotation)this.mockAppNode.getOrCreateAnnotation((Class)Mockito.eq(MUnitDeclarationsAnnotation.class), (Supplier)Mockito.any()))).thenReturn((Object)this.mockMUnitDeclarations);
        Mockito.when((Object)this.mockFlowNode.getIdentifier()).thenReturn((Object)this.mockIdentifier);
    }

    @Test
    public void testAnnotateBeforeTest() {
        Mockito.when((Object)this.mockFlowNode.getIdentifier()).thenReturn((Object)DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST);
        this.annotator.annotate(this.mockFlowNode, this.mockContext);
        ((MUnitDeclarationsAnnotation)Mockito.verify((Object)this.mockMUnitDeclarations)).setBeforeTestMuleFlowNode(this.mockFlowNode);
    }

    @Test
    public void testAnnotateAfterTest() {
        Mockito.when((Object)this.mockFlowNode.getIdentifier()).thenReturn((Object)DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST);
        this.annotator.annotate(this.mockFlowNode, this.mockContext);
        ((MUnitDeclarationsAnnotation)Mockito.verify((Object)this.mockMUnitDeclarations)).setAfterTestMuleFlowNode(this.mockFlowNode);
    }

    @Test
    public void testAnnotateBeforeSuite() {
        Mockito.when((Object)this.mockFlowNode.getIdentifier()).thenReturn((Object)DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE);
        this.annotator.annotate(this.mockFlowNode, this.mockContext);
        ((MUnitDeclarationsAnnotation)Mockito.verify((Object)this.mockMUnitDeclarations)).setBeforeSuiteMuleFlowNode(this.mockFlowNode);
    }

    @Test
    public void testAnnotateAfterSuite() {
        Mockito.when((Object)this.mockFlowNode.getIdentifier()).thenReturn((Object)DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE);
        this.annotator.annotate(this.mockFlowNode, this.mockContext);
        ((MUnitDeclarationsAnnotation)Mockito.verify((Object)this.mockMUnitDeclarations)).setAfterSuiteMuleFlowNode(this.mockFlowNode);
    }

    @Test
    public void testAnnotateUnknownIdentifier() {
        this.annotator.annotate(this.mockFlowNode, this.mockContext);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockMUnitDeclarations});
    }
}

