/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.ParseTemplateTypeResolver;

public class ParseTemplateTypeResolverTest {
    private ParseTemplateTypeResolver resolver;
    @Mock
    private MessageProcessorNode mockMessageProcessorNode;
    @Mock
    private TypingMuleAstVisitor mockTypingMuleAstVisitor;
    @Mock
    private TypingMuleAstVisitorContext mockVisitorContext;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.resolver = new ParseTemplateTypeResolver();
    }

    @Test
    public void testGetComponentModelType() {
        Optional result = this.resolver.getComponentModelType();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)ComponentModelType.MESSAGE_PROCESSOR_NODE, result.get());
    }

    @Test
    public void testResolve() {
        EventType inputEventType = new EventType();
        EventType result = this.resolver.resolve(this.mockMessageProcessorNode, inputEventType, this.mockTypingMuleAstVisitor, this.mockVisitorContext);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof EventType));
        ((MessageProcessorNode)Mockito.verify((Object)this.mockMessageProcessorNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)Mockito.any(UsesTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.mockMessageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
    }

    @Test
    public void testResolveAnnotations() {
        EventType inputEventType = new EventType();
        EventType result = this.resolver.resolve(this.mockMessageProcessorNode, inputEventType, this.mockTypingMuleAstVisitor, this.mockVisitorContext);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testIsPropagates() {
        Assert.assertTrue((boolean)this.resolver.isPropagates(this.mockMessageProcessorNode));
    }

    @Test
    public void testResolveOutputType() {
        EventType inputEventType = new EventType();
        EventType result = this.resolver.resolve(this.mockMessageProcessorNode, inputEventType, this.mockTypingMuleAstVisitor, this.mockVisitorContext);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof EventType));
    }
}

