/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util.metadatatype;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.datasense.impl.model.types.MetadataTypeTransform;
import org.mule.datasense.impl.util.matchers.MetadataTypeMatcher;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TupleTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.internal.utils.MetadataTypeWriter;

public class MetadataTypeBasicTransformTest {
    private void checkResult(BaseTypeBuilder typeBuilder) throws IOException {
        MetadataType metadataType = typeBuilder.build();
        String expected = new MetadataTypeWriter().toString(metadataType);
        MetadataTypeTransform metadataTypeTransform = new MetadataTypeTransform();
        MetadataType transformedMetadataType = metadataTypeTransform.transform(metadataType);
        Assert.assertThat((Object)transformedMetadataType, (Matcher)new MetadataTypeMatcher.IsAs(expected));
    }

    private BaseTypeBuilder getTypeBuilder() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
    }

    @Test
    public void objectBuilder() throws IOException {
        BaseTypeBuilder typeBuilder = this.getTypeBuilder();
        ObjectTypeBuilder object = typeBuilder.objectType();
        object.addField().key("name").value().stringType();
        object.addField().key("age").with((TypeAnnotation)new LabelAnnotation("Age")).value().numberType();
        object.addField().required(true).key("male").value().booleanType();
        object.addField().key("friends").value().arrayType().of().objectType().addField().key("id").value().stringType();
        this.checkResult(typeBuilder);
    }

    @Test
    public void arrayBuilder() throws IOException {
        BaseTypeBuilder typeBuilder = this.getTypeBuilder();
        typeBuilder.arrayType().of().stringType();
        this.checkResult(typeBuilder);
    }

    @Test
    public void tupleBuilder() throws IOException {
        BaseTypeBuilder typeBuilder = this.getTypeBuilder();
        TupleTypeBuilder tupleType = typeBuilder.tupleType();
        tupleType.of().stringType();
        tupleType.of().numberType();
        this.checkResult(typeBuilder);
    }

    @Test
    public void unionBuilder() throws IOException {
        BaseTypeBuilder typeBuilder = this.getTypeBuilder();
        UnionTypeBuilder unionTypeBuilder = typeBuilder.unionType();
        unionTypeBuilder.of((MetadataType)this.getTypeBuilder().stringType().build());
        unionTypeBuilder.of().numberType();
        this.checkResult(typeBuilder);
    }

    @Test
    public void enumType() throws IOException {
        BaseTypeBuilder enumType = this.getTypeBuilder();
        enumType.stringType().enumOf(new String[]{"Red", "Green", "Blue"});
        this.checkResult(enumType);
    }

    @Test
    @Ignore
    public void arrayOfArraysType() throws IOException {
        BaseTypeBuilder typeBuilder = this.getTypeBuilder();
        ArrayTypeBuilder arrayBuilder = typeBuilder.arrayType();
        BaseTypeBuilder elementTypeBuilder = this.getTypeBuilder();
        elementTypeBuilder.arrayType().of().stringType();
        arrayBuilder.of((TypeBuilder)elementTypeBuilder);
        this.checkResult(typeBuilder);
    }

    @Test
    @Ignore
    public void arrayOfIndirectRecursive() throws IOException {
        BaseTypeBuilder typeBuilder = this.getTypeBuilder();
        ArrayTypeBuilder arrayBuilder1 = typeBuilder.arrayType();
        ArrayTypeBuilder arrayBuilder11 = this.getTypeBuilder().arrayType();
        arrayBuilder1.of((TypeBuilder)arrayBuilder11);
        arrayBuilder11.of((TypeBuilder)arrayBuilder1);
        this.checkResult(typeBuilder);
    }

    @Test
    public void functionType() throws IOException {
        BaseTypeBuilder typeBuilder = this.getTypeBuilder();
        FunctionTypeBuilder functionBuild = typeBuilder.functionType();
        functionBuild.addParameterOf("value").arrayType().of().stringType();
        functionBuild.returnType().stringType();
        this.checkResult(typeBuilder);
    }

    @Test
    public void functionTypeUsingTypeBuildersForParametersAndReturn() throws IOException {
        BaseTypeBuilder typeBuilder = this.getTypeBuilder();
        FunctionTypeBuilder functionBuild = typeBuilder.functionType();
        BaseTypeBuilder parameterTypeBuilder = this.getTypeBuilder();
        parameterTypeBuilder.arrayType().of().stringType();
        functionBuild.addParameterOf("value", (TypeBuilder)parameterTypeBuilder);
        BaseTypeBuilder returnTypeBuilder = this.getTypeBuilder();
        returnTypeBuilder.stringType();
        functionBuild.returnType((TypeBuilder)returnTypeBuilder);
        this.checkResult(typeBuilder);
    }

    @Test
    public void functionTypeUsingTypesForParametersAndReturn() throws IOException {
        BaseTypeBuilder typeBuilder = this.getTypeBuilder();
        FunctionTypeBuilder functionBuild = typeBuilder.functionType();
        BaseTypeBuilder parameterTypeBuilder = this.getTypeBuilder();
        parameterTypeBuilder.arrayType().of().stringType();
        functionBuild.addParameterOf("value", parameterTypeBuilder.build());
        BaseTypeBuilder returnTypeBuilder = this.getTypeBuilder();
        returnTypeBuilder.stringType();
        functionBuild.returnType(returnTypeBuilder.build());
        this.checkResult(typeBuilder);
    }

    @Test
    public void voidFunctionType() throws IOException {
        BaseTypeBuilder typeBuilder = this.getTypeBuilder();
        FunctionTypeBuilder functionBuild = typeBuilder.functionType();
        functionBuild.addParameterOf("value").arrayType().of().stringType();
        this.checkResult(typeBuilder);
    }

    @Test
    public void functionNoArgumentsType() throws IOException {
        BaseTypeBuilder typeBuilder = this.getTypeBuilder();
        FunctionTypeBuilder functionBuild = typeBuilder.functionType();
        functionBuild.returnType().stringType();
        this.checkResult(typeBuilder);
    }

    @Test
    public void simpleTypes() throws IOException {
        BaseTypeBuilder typeBuilder = this.getTypeBuilder();
        ObjectTypeBuilder object = typeBuilder.objectType();
        object.addField().key("stringType").value().stringType();
        object.addField().key("numberType").value().numberType();
        object.addField().key("booleanType").value().booleanType();
        object.addField().key("dateTimeType").value().dateTimeType();
        object.addField().key("dateType").value().dateType();
        object.addField().key("anyType").value().anyType();
        object.addField().key("binaryType").value().binaryType();
        object.addField().key("nullType").value().nullType();
        object.addField().key("localDateTimeType").value().localDateTimeType();
        object.addField().key("localTimeType").value().localTimeType();
        object.addField().key("nothingType").value().nothingType();
        object.addField().key("periodType").value().periodType();
        object.addField().key("regexType").value().regexType();
        object.addField().key("timeZoneType").value().timeZoneType();
        this.checkResult(typeBuilder);
    }
}

