/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.ThrowsErrorsTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.RaiseErrorTypeResolver;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

public class RaiseErrorTypeResolverTest {
    private RaiseErrorTypeResolver resolver;
    private MessageProcessorNode messageProcessorNode;
    private ComponentAst componentModel;
    private TypingMuleAstVisitor typingMuleAstVisitor;
    private TypingMuleAstVisitorContext visitorContext;

    @Before
    public void setUp() {
        this.resolver = new RaiseErrorTypeResolver();
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.componentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.typingMuleAstVisitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);
        this.visitorContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
    }

    @Test
    public void testGetComponentModelType() {
        Assert.assertEquals(Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE), (Object)this.resolver.getComponentModelType());
    }

    @Test
    public void testResolveWithErrorType() {
        ComponentParameterAst parameterModel = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentModel);
        Mockito.when((Object)this.componentModel.getParameter("General", "type")).thenReturn((Object)parameterModel);
        Mockito.when((Object)parameterModel.getValue()).thenReturn((Object)Either.right(null, (Object)"CUSTOM:ERROR"));
        ErrorModel errorModel = (ErrorModel)Mockito.mock(ErrorModel.class);
        EventType result = this.resolver.resolve(this.messageProcessorNode, new EventType(), this.typingMuleAstVisitor, this.visitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)Mockito.any(UsesTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((ThrowsErrorsTypeAnnotation)Mockito.any(ThrowsErrorsTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof EventType));
    }

    @Test
    public void testResolveWithoutErrorType() {
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn(null);
        EventType result = this.resolver.resolve(this.messageProcessorNode, new EventType(), this.typingMuleAstVisitor, this.visitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)Mockito.any(UsesTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).annotate((AstNodeAnnotation)((ThrowsErrorsTypeAnnotation)Mockito.any(ThrowsErrorsTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof EventType));
    }

    @Test
    public void testIsPropagates() {
        Assert.assertTrue((boolean)this.resolver.isPropagates(this.messageProcessorNode));
    }
}

