/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.util.AstMessageCallbackFactory;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

@RunWith(value=MockitoJUnitRunner.class)
public class AstMessageCallbackFactoryTest {
    @Mock
    private AstNotification mockAstNotification;
    @Mock
    private AstNodeLocation mockAstNodeLocation;
    private AstMessageCallbackFactory factory;

    @Before
    public void setUp() {
        this.factory = new AstMessageCallbackFactory(this.mockAstNotification, this.mockAstNodeLocation);
    }

    @Test
    public void testConstructorWithValidArguments() {
        Assert.assertNotNull((Object)this.factory);
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorWithNullAstNotification() {
        new AstMessageCallbackFactory(null, this.mockAstNodeLocation);
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorWithNullAstNodeLocation() {
        new AstMessageCallbackFactory(this.mockAstNotification, null);
    }

    @Test
    public void testCreateMessageCallback() {
        String testExpression = "testExpression";
        ExpressionLanguageMetadataService.MessageCallback callback = this.factory.createMessageCallback(testExpression);
        Assert.assertNotNull((Object)callback);
    }

    @Test
    public void testWarningCallback() {
        String testExpression = "testExpression";
        String testMessage = "Test warning message";
        ExpressionLanguageMetadataService.MessageLocation mockLocation = (ExpressionLanguageMetadataService.MessageLocation)Mockito.mock(ExpressionLanguageMetadataService.MessageLocation.class);
        ExpressionLanguageMetadataService.MessageCallback callback = this.factory.createMessageCallback(testExpression);
        callback.warning(testMessage, mockLocation);
        Assert.assertNotNull((Object)testExpression);
    }

    @Test
    public void testErrorCallback() {
        String testExpression = "testExpression";
        String testMessage = "Test error message";
        ExpressionLanguageMetadataService.MessageLocation mockLocation = (ExpressionLanguageMetadataService.MessageLocation)Mockito.mock(ExpressionLanguageMetadataService.MessageLocation.class);
        ExpressionLanguageMetadataService.MessageCallback callback = this.factory.createMessageCallback(testExpression);
        callback.error(testMessage, mockLocation);
        Assert.assertNotNull((Object)testExpression);
    }
}

