/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorNode;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorTreeUtils;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;

public class ErrorTreeUtilsTest {
    private ErrorModel createErrorModel(ErrorModelBuilder ... errors) {
        ArrayDeque stack = new ArrayDeque();
        Stream.of(errors).map(ErrorModelBuilder::build).forEach(stack::push);
        ErrorModel currentErrorModel = null;
        while (!stack.isEmpty()) {
            ErrorModel errorModel = (ErrorModel)stack.pop();
            currentErrorModel = ErrorModelBuilder.newError((String)errorModel.getType(), (String)errorModel.getNamespace()).withParent(currentErrorModel).build();
        }
        return currentErrorModel;
    }

    @Test
    public void test() {
        ErrorNode errorNode = ErrorTreeUtils.createTree(Arrays.asList(this.createErrorModel(ErrorModelBuilder.newError((String)"a11", (String)""), ErrorModelBuilder.newError((String)"a1", (String)""), ErrorModelBuilder.newError((String)"a", (String)"")), this.createErrorModel(ErrorModelBuilder.newError((String)"a12", (String)""), ErrorModelBuilder.newError((String)"a1", (String)""), ErrorModelBuilder.newError((String)"a", (String)"")), this.createErrorModel(ErrorModelBuilder.newError((String)"a21", (String)""), ErrorModelBuilder.newError((String)"a2", (String)""), ErrorModelBuilder.newError((String)"a", (String)"")), this.createErrorModel(ErrorModelBuilder.newError((String)"a22", (String)""), ErrorModelBuilder.newError((String)"a2", (String)""), ErrorModelBuilder.newError((String)"a", (String)"")), this.createErrorModel(ErrorModelBuilder.newError((String)"b11", (String)""), ErrorModelBuilder.newError((String)"b1", (String)""), ErrorModelBuilder.newError((String)"b", (String)"")), this.createErrorModel(ErrorModelBuilder.newError((String)"b12", (String)""), ErrorModelBuilder.newError((String)"b1", (String)""), ErrorModelBuilder.newError((String)"b", (String)"")), this.createErrorModel(ErrorModelBuilder.newError((String)"b21", (String)""), ErrorModelBuilder.newError((String)"b2", (String)""), ErrorModelBuilder.newError((String)"b", (String)"")), this.createErrorModel(ErrorModelBuilder.newError((String)"b22", (String)""), ErrorModelBuilder.newError((String)"b2", (String)""), ErrorModelBuilder.newError((String)"b", (String)"")), this.createErrorModel(ErrorModelBuilder.newError((String)"b22", (String)""), ErrorModelBuilder.newError((String)"b2", (String)""), ErrorModelBuilder.newError((String)"b", (String)"")), this.createErrorModel(ErrorModelBuilder.newError((String)"b3", (String)""), ErrorModelBuilder.newError((String)"b", (String)"")), this.createErrorModel(ErrorModelBuilder.newError((String)"c", (String)""))));
        ByteArrayOutputStream errors = new ByteArrayOutputStream();
        ErrorTreeUtils.dump((ErrorNode)errorNode, (PrintStream)new PrintStream(errors));
        Assert.assertEquals((Object)String.format("root%n\t:a%n\t\t:a1%n\t\t\t:a11%n\t\t\t:a12%n\t\t:a2%n\t\t\t:a21%n\t\t\t:a22%n\t:b%n\t\t:b1%n\t\t\t:b11%n\t\t\t:b12%n\t\t:b2%n\t\t\t:b21%n\t\t\t:b22%n\t\t:b3%n\t:c%n", new Object[0]), (Object)errors.toString());
    }
}

