/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.ParallelForEachTypeResolver;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

public class ParallelForEachTypeResolverTest {
    private ParallelForEachTypeResolver resolver;
    private MessageProcessorNode messageProcessorNode;
    private EventType inputEventType;
    private EventType innerEventType;
    private TypingMuleAstVisitor typingMuleAstVisitor;
    private TypingMuleAstVisitorContext typingMuleAstVisitorContext;

    @Before
    public void setUp() {
        this.resolver = new ParallelForEachTypeResolver();
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.inputEventType = (EventType)Mockito.mock(EventType.class);
        this.innerEventType = (EventType)Mockito.mock(EventType.class);
        this.typingMuleAstVisitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);
        this.typingMuleAstVisitorContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
    }

    @Test
    public void testResolveOutputEventType() {
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        Mockito.when((Object)this.typingMuleAstVisitorContext.getAstNotification()).thenReturn((Object)((AstNotification)Mockito.mock(AstNotification.class)));
        Mockito.when((Object)this.messageProcessorNode.getAstNodeLocation()).thenReturn((Object)((AstNodeLocation)Mockito.mock(AstNodeLocation.class)));
        EventType outputEventType = this.resolver.resolveOutputEventType(this.messageProcessorNode, this.inputEventType, this.innerEventType, this.typingMuleAstVisitor, this.typingMuleAstVisitorContext);
        Assert.assertNotNull((Object)outputEventType);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
    }

    @Test
    public void testGetComponentIdentifierForeachScopeIn() {
        ComponentIdentifier identifier = this.resolver.getComponentIdentifierForeachScopeIn();
        Assert.assertEquals((Object)DefaultDataSense.COMPONENT_IDENTIFIER_PARALLEL_FOREACH_SCOPE_IN, (Object)identifier);
    }

    @Test
    @Ignore
    public void testProcessTarget() {
        ComponentAst componentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)componentModel);
        EventType result = this.resolver.processTarget(this.inputEventType, this.messageProcessorNode, this.typingMuleAstVisitorContext);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testParallelForEachScopeIn() {
        ParallelForEachTypeResolver.ParallelForEachScopeIn scopeIn = new ParallelForEachTypeResolver.ParallelForEachScopeIn();
        Assert.assertEquals((Object)"index", (Object)scopeIn.getDefaultCounterVariableName());
    }
}

