/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.tooling;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.ExpectedEventAnnotation;
import org.mule.datasense.impl.model.annotations.ExpectedInputAnnotation;
import org.mule.datasense.impl.model.annotations.IncomingEventAnnotation;
import org.mule.datasense.impl.model.annotations.ResultEventAnnotation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.tooling.TypeContextQuery;
import org.mule.runtime.api.component.location.Location;

@RunWith(value=MockitoJUnitRunner.class)
public class TypeContextQueryTest {
    @Mock
    private MuleApplicationNode mockMuleApplicationNode;
    @Mock
    private DataSenseProviderResolver mockDataSenseProviderResolver;
    @Mock
    private AstNotification mockAstNotification;
    @Mock
    private MessageProcessorNode mockMessageProcessorNode;
    @Mock
    private Location mockLocation;
    private TypeContextQuery typeContextQuery;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.typeContextQuery = new TypeContextQuery(this.mockLocation);
    }

    @Test
    public void testPerformWithNoAnnotationsPresent() {
        Mockito.when((Object)this.mockMuleApplicationNode.findMessageProcessorNode(this.mockLocation)).thenReturn(Optional.of(this.mockMessageProcessorNode));
        IncomingEventAnnotation incomingEventAnnotation = (IncomingEventAnnotation)Mockito.mock(IncomingEventAnnotation.class);
        ExpectedEventAnnotation expectedEventAnnotation = (ExpectedEventAnnotation)Mockito.mock(ExpectedEventAnnotation.class);
        ResultEventAnnotation resultEventAnnotation = (ResultEventAnnotation)Mockito.mock(ResultEventAnnotation.class);
        ExpectedInputAnnotation expectedInputAnnotation = (ExpectedInputAnnotation)Mockito.mock(ExpectedInputAnnotation.class);
        Mockito.when((Object)this.mockMessageProcessorNode.getAnnotation(IncomingEventAnnotation.class)).thenReturn(Optional.of(incomingEventAnnotation));
        Mockito.when((Object)this.mockMessageProcessorNode.getAnnotation(ExpectedEventAnnotation.class)).thenReturn(Optional.of(expectedEventAnnotation));
        Mockito.when((Object)this.mockMessageProcessorNode.getAnnotation(ResultEventAnnotation.class)).thenReturn(Optional.of(resultEventAnnotation));
        Mockito.when((Object)this.mockMessageProcessorNode.getAnnotation(ExpectedInputAnnotation.class)).thenReturn(Optional.of(expectedInputAnnotation));
        Mockito.when((Object)incomingEventAnnotation.getEventType()).thenReturn((Object)((EventType)Mockito.mock(EventType.class)));
        Mockito.when((Object)expectedEventAnnotation.getEventType()).thenReturn((Object)((EventType)Mockito.mock(EventType.class)));
        Mockito.when((Object)resultEventAnnotation.getResultEventType()).thenReturn((Object)((EventType)Mockito.mock(EventType.class)));
        Mockito.when((Object)expectedInputAnnotation.getEventType()).thenReturn((Object)((EventType)Mockito.mock(EventType.class)));
        Optional result = this.typeContextQuery.perform(this.mockMuleApplicationNode, this.mockDataSenseProviderResolver, this.mockAstNotification);
        Assert.assertTrue((boolean)result.isPresent());
    }

    @Test
    public void testPerformWithMessageProcessorNodeNotFound() {
        Mockito.when((Object)this.mockMuleApplicationNode.findMessageProcessorNode(this.mockLocation)).thenReturn(Optional.empty());
        Optional result = this.typeContextQuery.perform(this.mockMuleApplicationNode, this.mockDataSenseProviderResolver, this.mockAstNotification);
        Assert.assertFalse((boolean)result.isPresent());
    }
}

